/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.grammar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.matcher.AdjacentMatcher;
import com.sonar.sslr.impl.matcher.AnyTokenButNotMatcher;
import com.sonar.sslr.impl.matcher.AnyTokenMatcher;
import com.sonar.sslr.impl.matcher.BooleanMatcher;
import com.sonar.sslr.impl.matcher.BridgeMatcher;
import com.sonar.sslr.impl.matcher.ExclusiveTillMatcher;
import com.sonar.sslr.impl.matcher.InclusiveTillMatcher;
import com.sonar.sslr.impl.matcher.NextMatcher;
import com.sonar.sslr.impl.matcher.NotMatcher;
import com.sonar.sslr.impl.matcher.OneToNMatcher;
import com.sonar.sslr.impl.matcher.OptMatcher;
import com.sonar.sslr.impl.matcher.OrMatcher;
import com.sonar.sslr.impl.matcher.TillNewLineMatcher;
import com.sonar.sslr.impl.matcher.TokenTypesMatcher;
import java.util.Arrays;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.LexerfulGrammarAdapter;
import org.sonar.sslr.internal.grammar.LexerfulGrammarRuleDefinition;
import org.sonar.sslr.internal.grammar.MatcherBuilderUtils;
import org.sonar.sslr.internal.grammar.ReflexiveMatcherBuilder;

public class LexerfulGrammarBuilder {
    private final Map<GrammarRuleKey, LexerfulGrammarRuleDefinition> definitions = Maps.newHashMap();
    private GrammarRuleKey rootRuleKey;

    public static LexerfulGrammarBuilder create() {
        return new LexerfulGrammarBuilder(new LexerfulGrammarBuilder[0]);
    }

    public static LexerfulGrammarBuilder createBasedOn(LexerfulGrammarBuilder ... base) {
        return new LexerfulGrammarBuilder(base);
    }

    private LexerfulGrammarBuilder(LexerfulGrammarBuilder ... base) {
        for (LexerfulGrammarBuilder b : base) {
            this.definitions.putAll(b.definitions);
        }
    }

    public GrammarRuleBuilder rule(GrammarRuleKey ruleKey) {
        LexerfulGrammarRuleDefinition definition = this.definitions.get(ruleKey);
        if (definition == null) {
            definition = new LexerfulGrammarRuleDefinition(ruleKey);
            this.definitions.put(ruleKey, definition);
        }
        return definition;
    }

    public void setRootRule(GrammarRuleKey ruleKey) {
        this.rule(ruleKey);
        this.rootRuleKey = ruleKey;
    }

    public Grammar build() {
        return new LexerfulGrammarAdapter(this.definitions.values(), this.rootRuleKey, false);
    }

    public Grammar buildWithMemoizationOfMatchesForAllRules() {
        return new LexerfulGrammarAdapter(this.definitions.values(), this.rootRuleKey, true);
    }

    public Object sequence(Object e1, Object e2) {
        return MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e1, e2));
    }

    public Object sequence(Object e1, Object e2, Object ... rest) {
        return MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object)e2, (Object[])rest));
    }

    public Object firstOf(Object e1, Object e2) {
        return new ReflexiveMatcherBuilder(OrMatcher.class, MatcherBuilderUtils.lexerfulToMatcherBuilders(Arrays.asList(e1, e2)));
    }

    public Object firstOf(Object e1, Object e2, Object ... rest) {
        return new ReflexiveMatcherBuilder(OrMatcher.class, MatcherBuilderUtils.lexerfulToMatcherBuilders(Lists.asList((Object)e1, (Object)e2, (Object[])rest)));
    }

    public Object optional(Object e) {
        return new ReflexiveMatcherBuilder(OptMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object optional(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(OptMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object oneOrMore(Object e) {
        return new ReflexiveMatcherBuilder(OneToNMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object oneOrMore(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(OneToNMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object zeroOrMore(Object e) {
        return this.optional(new ReflexiveMatcherBuilder(OneToNMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e))}));
    }

    public Object zeroOrMore(Object e1, Object ... rest) {
        return this.optional(new ReflexiveMatcherBuilder(OneToNMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))}));
    }

    public Object next(Object e) {
        return new ReflexiveMatcherBuilder(NextMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object next(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(NextMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object nextNot(Object e) {
        return new ReflexiveMatcherBuilder(NotMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object nextNot(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(NotMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object nothing() {
        return new ReflexiveMatcherBuilder(BooleanMatcher.class, new Object[]{false});
    }

    public Object adjacent(Object element) {
        return new ReflexiveMatcherBuilder(AdjacentMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToMatcherBuilder(element)});
    }

    public Object anyTokenButNot(Object element) {
        return new ReflexiveMatcherBuilder(AnyTokenButNotMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToMatcherBuilder(element)});
    }

    public Object isOneOfThem(TokenType t1, TokenType ... others) {
        TokenType[] types = new TokenType[1 + others.length];
        types[0] = t1;
        System.arraycopy(others, 0, types, 1, others.length);
        return new ReflexiveMatcherBuilder(TokenTypesMatcher.class, new Object[]{types});
    }

    public Object bridge(TokenType from, TokenType to) {
        return new ReflexiveMatcherBuilder(BridgeMatcher.class, new Object[]{from, to});
    }

    public Object everything() {
        return new ReflexiveMatcherBuilder(BooleanMatcher.class, new Object[]{true});
    }

    public Object anyToken() {
        return new ReflexiveMatcherBuilder(AnyTokenMatcher.class, new Object[0]);
    }

    public Object tillNewLine() {
        return new ReflexiveMatcherBuilder(TillNewLineMatcher.class, new Object[0]);
    }

    public Object till(Object e) {
        return new ReflexiveMatcherBuilder(InclusiveTillMatcher.class, new Object[]{MatcherBuilderUtils.lexerfulToMatcherBuilder(e)});
    }

    public Object exclusiveTill(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(ExclusiveTillMatcher.class, MatcherBuilderUtils.lexerfulToMatcherBuilders(Lists.asList((Object)e1, (Object[])rest)));
    }
}

