/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.grammar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.util.Arrays;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.LexerlessGrammarAdapter;
import org.sonar.sslr.internal.grammar.LexerlessGrammarRuleDefinition;
import org.sonar.sslr.internal.grammar.MatcherBuilderUtils;
import org.sonar.sslr.internal.grammar.ReflexiveMatcherBuilder;
import org.sonar.sslr.internal.matchers.EndOfInputMatcher;
import org.sonar.sslr.internal.matchers.FirstOfMatcher;
import org.sonar.sslr.internal.matchers.NothingMatcher;
import org.sonar.sslr.internal.matchers.OneOrMoreMatcher;
import org.sonar.sslr.internal.matchers.OptionalMatcher;
import org.sonar.sslr.internal.matchers.PatternMatcher;
import org.sonar.sslr.internal.matchers.TestMatcher;
import org.sonar.sslr.internal.matchers.TestNotMatcher;
import org.sonar.sslr.internal.matchers.TokenMatcher;
import org.sonar.sslr.internal.matchers.TriviaMatcher;
import org.sonar.sslr.internal.matchers.ZeroOrMoreMatcher;
import org.sonar.sslr.parser.LexerlessGrammar;

public class LexerlessGrammarBuilder {
    private final Map<GrammarRuleKey, LexerlessGrammarRuleDefinition> definitions = Maps.newHashMap();
    private GrammarRuleKey rootRuleKey;

    public static LexerlessGrammarBuilder create() {
        return new LexerlessGrammarBuilder(new LexerlessGrammarBuilder[0]);
    }

    public static LexerlessGrammarBuilder createBasedOn(LexerlessGrammarBuilder ... base) {
        return new LexerlessGrammarBuilder(base);
    }

    private LexerlessGrammarBuilder(LexerlessGrammarBuilder ... base) {
        for (LexerlessGrammarBuilder b : base) {
            this.definitions.putAll(b.definitions);
        }
    }

    public GrammarRuleBuilder rule(GrammarRuleKey ruleKey) {
        LexerlessGrammarRuleDefinition definition = this.definitions.get(ruleKey);
        if (definition == null) {
            definition = new LexerlessGrammarRuleDefinition(ruleKey);
            this.definitions.put(ruleKey, definition);
        }
        return definition;
    }

    public void setRootRule(GrammarRuleKey ruleKey) {
        this.rule(ruleKey);
        this.rootRuleKey = ruleKey;
    }

    public LexerlessGrammar build() {
        return new LexerlessGrammarAdapter(this.definitions.values(), this.rootRuleKey);
    }

    public Object sequence(Object e1, Object e2) {
        return MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e1, e2));
    }

    public Object sequence(Object e1, Object e2, Object ... rest) {
        return MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object)e2, (Object[])rest));
    }

    public Object firstOf(Object e1, Object e2) {
        return new ReflexiveMatcherBuilder(FirstOfMatcher.class, MatcherBuilderUtils.lexerlessToMatcherBuilders(Arrays.asList(e1, e2)));
    }

    public Object firstOf(Object e1, Object e2, Object ... rest) {
        return new ReflexiveMatcherBuilder(FirstOfMatcher.class, MatcherBuilderUtils.lexerlessToMatcherBuilders(Lists.asList((Object)e1, (Object)e2, (Object[])rest)));
    }

    public Object optional(Object e) {
        return new ReflexiveMatcherBuilder(OptionalMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object optional(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(OptionalMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object oneOrMore(Object e) {
        return new ReflexiveMatcherBuilder(OneOrMoreMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object oneOrMore(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(OneOrMoreMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object zeroOrMore(Object e) {
        return new ReflexiveMatcherBuilder(ZeroOrMoreMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object zeroOrMore(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(ZeroOrMoreMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object next(Object e) {
        return new ReflexiveMatcherBuilder(TestMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object next(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(TestMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object nextNot(Object e) {
        return new ReflexiveMatcherBuilder(TestNotMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Arrays.asList(e))});
    }

    public Object nextNot(Object e1, Object ... rest) {
        return new ReflexiveMatcherBuilder(TestNotMatcher.class, new Object[]{MatcherBuilderUtils.lexerlessToSingleMatcherBuilder(Lists.asList((Object)e1, (Object[])rest))});
    }

    public Object nothing() {
        return new ReflexiveMatcherBuilder(NothingMatcher.class, new Object[0]);
    }

    public Object regexp(String regexp) {
        return new ReflexiveMatcherBuilder(PatternMatcher.class, new Object[]{regexp});
    }

    public Object endOfInput() {
        return new ReflexiveMatcherBuilder(EndOfInputMatcher.class, new Object[0]);
    }

    public Object token(TokenType tokenType, Object e) {
        return new ReflexiveMatcherBuilder(TokenMatcher.class, new Object[]{tokenType, MatcherBuilderUtils.lexerlessToMatcherBuilder(e)});
    }

    public Object commentTrivia(Object e) {
        return new ReflexiveMatcherBuilder(TriviaMatcher.class, new Object[]{Trivia.TriviaKind.COMMENT, MatcherBuilderUtils.lexerlessToMatcherBuilder(e)});
    }

    public Object skippedTrivia(Object e) {
        return new ReflexiveMatcherBuilder(TriviaMatcher.class, new Object[]{Trivia.TriviaKind.SKIPPED_TEXT, MatcherBuilderUtils.lexerlessToMatcherBuilder(e)});
    }
}

