/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.Collection;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.LexerfulGrammarRuleDefinition;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerfulGrammarAdapter
extends LexerlessGrammar {
    private final Map<GrammarRuleKey, RuleDefinition> ruleMatchers;
    private final Rule rootRule;

    public LexerfulGrammarAdapter(Collection<LexerfulGrammarRuleDefinition> rules, GrammarRuleKey rootRuleKey, boolean enableMemoizationOfMathesForAllRules) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (LexerfulGrammarRuleDefinition definition : rules) {
            GrammarRuleKey ruleKey = definition.getRule();
            b.put((Object)ruleKey, (Object)RuleDefinition.newRuleBuilder(definition.getName(), ruleKey));
        }
        this.ruleMatchers = b.build();
        for (LexerfulGrammarRuleDefinition definition : rules) {
            definition.build(this);
        }
        if (enableMemoizationOfMathesForAllRules) {
            for (RuleDefinition ruleDefinition : this.ruleMatchers.values()) {
                ruleDefinition.getRule().memoizeMatches();
            }
        }
        this.rootRule = this.ruleMatchers.get(rootRuleKey);
    }

    @Override
    public Rule getRootRule() {
        return this.rootRule;
    }

    @Override
    public Rule rule(GrammarRuleKey ruleKey) {
        return this.ruleMatchers.get(ruleKey);
    }

    @VisibleForTesting
    public Collection<GrammarRuleKey> ruleKeys() {
        return this.ruleMatchers.keySet();
    }
}

