/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Rule;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MatcherBuilder;
import org.sonar.sslr.internal.grammar.MatcherBuilderUtils;

public class LexerfulGrammarRuleDefinition
implements GrammarRuleBuilder {
    private final GrammarRuleKey rule;
    private MatcherBuilder[] matcherBuilders;
    private SkipState skipState;
    private boolean isRecoveryRule;

    public LexerfulGrammarRuleDefinition(GrammarRuleKey rule) {
        this.rule = rule;
        this.matcherBuilders = null;
        this.skipState = SkipState.DO_NOT_SKIP;
        this.isRecoveryRule = false;
    }

    public String getName() {
        return this.rule.toString();
    }

    public GrammarRuleKey getRule() {
        return this.rule;
    }

    public GrammarRuleBuilder is(Object e) {
        if (this.matcherBuilders != null) {
            throw new GrammarException("The rule '" + this.getName() + "' has already been defined somewhere in the grammar.");
        }
        this.setMatcherBuilders(e, new Object[0]);
        return this;
    }

    public LexerfulGrammarRuleDefinition is(Object e1, Object ... others) {
        if (this.matcherBuilders != null) {
            throw new GrammarException("The rule '" + this.getName() + "' has already been defined somewhere in the grammar.");
        }
        this.setMatcherBuilders(e1, others);
        return this;
    }

    public LexerfulGrammarRuleDefinition override(Object e) {
        this.setMatcherBuilders(e, new Object[0]);
        return this;
    }

    public LexerfulGrammarRuleDefinition override(Object e1, Object ... others) {
        this.setMatcherBuilders(e1, others);
        return this;
    }

    private void setMatcherBuilders(Object e1, Object ... others) {
        this.matcherBuilders = MatcherBuilderUtils.lexerfulToMatcherBuilders(Lists.asList((Object)e1, (Object[])others));
    }

    public void skip() {
        this.skipState = SkipState.ALWAYS_SKIP;
    }

    public void skipIfOneChild() {
        this.skipState = SkipState.SKIP_IF_ONE_CHILD;
    }

    public void recoveryRule() {
        this.isRecoveryRule = true;
    }

    public void build(Grammar g) {
        if (this.matcherBuilders == null) {
            throw new GrammarException("The rule '" + this.getName() + "' hasn't beed defined.");
        }
        Rule ruleMatcher = g.rule(this.rule);
        ruleMatcher.is(MatcherBuilderUtils.build(g, this.matcherBuilders));
        switch (this.skipState) {
            case ALWAYS_SKIP: {
                ruleMatcher.skip();
                break;
            }
            case SKIP_IF_ONE_CHILD: {
                ruleMatcher.skipIfOneChild();
                break;
            }
        }
        if (this.isRecoveryRule) {
            ruleMatcher.recoveryRule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SkipState {
        DO_NOT_SKIP,
        ALWAYS_SKIP,
        SKIP_IF_ONE_CHILD;

    }
}

