/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.Rule;
import java.util.Collection;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.LexerlessGrammarRuleDefinition;
import org.sonar.sslr.internal.matchers.GrammarElementMatcher;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerlessGrammarAdapter
extends LexerlessGrammar {
    private final Map<GrammarRuleKey, GrammarElementMatcher> ruleMatchers;
    private final Rule rootRule;

    public LexerlessGrammarAdapter(Collection<LexerlessGrammarRuleDefinition> rules, GrammarRuleKey rootRuleKey) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (LexerlessGrammarRuleDefinition definition : rules) {
            GrammarRuleKey ruleKey = definition.getRuleKey();
            b.put((Object)ruleKey, (Object)new GrammarElementMatcher(definition.getName(), ruleKey));
        }
        this.ruleMatchers = b.build();
        for (LexerlessGrammarRuleDefinition definition : rules) {
            definition.build(this);
        }
        this.rootRule = this.ruleMatchers.get(rootRuleKey);
    }

    @Override
    public Rule getRootRule() {
        return this.rootRule;
    }

    @Override
    public Rule rule(GrammarRuleKey ruleKey) {
        return this.ruleMatchers.get(ruleKey);
    }

    @VisibleForTesting
    public Collection<GrammarRuleKey> ruleKeys() {
        return this.ruleMatchers.keySet();
    }
}

