/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.matcher.AndMatcher;
import com.sonar.sslr.impl.matcher.TokenTypeClassMatcher;
import com.sonar.sslr.impl.matcher.TokenTypeMatcher;
import com.sonar.sslr.impl.matcher.TokenValueMatcher;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MatcherBuilder;
import org.sonar.sslr.internal.grammar.ReflexiveMatcherBuilder;
import org.sonar.sslr.internal.grammar.RuleMatcherBuilder;
import org.sonar.sslr.internal.matchers.SequenceMatcher;
import org.sonar.sslr.internal.matchers.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatcherBuilderUtils {
    private MatcherBuilderUtils() {
    }

    public static MatcherBuilder lexerlessToSingleMatcherBuilder(List<Object> elements) {
        if (elements.size() == 1) {
            return MatcherBuilderUtils.lexerlessToMatcherBuilder(elements.get(0));
        }
        return new ReflexiveMatcherBuilder(SequenceMatcher.class, MatcherBuilderUtils.lexerlessToMatcherBuilders(elements));
    }

    public static MatcherBuilder[] lexerlessToMatcherBuilders(List<Object> elements) {
        MatcherBuilder[] matcherBuilders = new MatcherBuilder[elements.size()];
        for (int i = 0; i < matcherBuilders.length; ++i) {
            matcherBuilders[i] = MatcherBuilderUtils.lexerlessToMatcherBuilder(elements.get(i));
        }
        return matcherBuilders;
    }

    public static MatcherBuilder lexerlessToMatcherBuilder(Object element) {
        Preconditions.checkNotNull((Object)element, (Object)"Incorrect parsing expression: null");
        if (element instanceof MatcherBuilder) {
            return (MatcherBuilder)element;
        }
        if (element instanceof GrammarRuleKey) {
            return new RuleMatcherBuilder((GrammarRuleKey)element);
        }
        if (element instanceof String) {
            return new ReflexiveMatcherBuilder(StringMatcher.class, new Object[]{element});
        }
        if (element instanceof Character) {
            return new ReflexiveMatcherBuilder(StringMatcher.class, new Object[]{Character.toString(((Character)element).charValue())});
        }
        throw new IllegalArgumentException("Incorrect type of parsing expression: " + element.getClass().getName());
    }

    public static MatcherBuilder lexerfulToSingleMatcherBuilder(List<Object> elements) {
        if (elements.size() == 1) {
            return MatcherBuilderUtils.lexerfulToMatcherBuilder(elements.get(0));
        }
        return new ReflexiveMatcherBuilder(AndMatcher.class, MatcherBuilderUtils.lexerfulToMatcherBuilders(elements));
    }

    public static MatcherBuilder[] lexerfulToMatcherBuilders(List<Object> elements) {
        MatcherBuilder[] matcherBuilders = new MatcherBuilder[elements.size()];
        for (int i = 0; i < matcherBuilders.length; ++i) {
            matcherBuilders[i] = MatcherBuilderUtils.lexerfulToMatcherBuilder(elements.get(i));
        }
        return matcherBuilders;
    }

    public static MatcherBuilder lexerfulToMatcherBuilder(Object element) {
        Preconditions.checkNotNull((Object)element, (Object)"Incorrect parsing expression: null");
        if (element instanceof MatcherBuilder) {
            return (MatcherBuilder)element;
        }
        if (element instanceof GrammarRuleKey) {
            return new RuleMatcherBuilder((GrammarRuleKey)element);
        }
        if (element instanceof String) {
            return new ReflexiveMatcherBuilder(TokenValueMatcher.class, new Object[]{element, false});
        }
        if (element instanceof TokenType) {
            TokenType tokenType = (TokenType)element;
            return new ReflexiveMatcherBuilder(TokenTypeMatcher.class, new Object[]{tokenType, tokenType.hasToBeSkippedFromAst(null)});
        }
        if (element instanceof Class) {
            return new ReflexiveMatcherBuilder(TokenTypeClassMatcher.class, new Object[]{element});
        }
        throw new IllegalArgumentException("Incorrect type of parsing expression: " + element.getClass().getName());
    }

    public static Object[] build(Grammar g, MatcherBuilder[] elements) {
        Object[] matchers = new Object[elements.length];
        for (int i = 0; i < matchers.length; ++i) {
            matchers[i] = elements[i].build(g);
        }
        return matchers;
    }
}

