/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.grammar;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.lang.reflect.Constructor;
import org.sonar.sslr.internal.grammar.MatcherBuilder;
import org.sonar.sslr.internal.matchers.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflexiveMatcherBuilder
implements MatcherBuilder {
    private final Class<?> matcherClass;
    private final Object[] arguments;

    public ReflexiveMatcherBuilder(Class<?> matcherClass, Object[] params) {
        this.matcherClass = matcherClass;
        this.arguments = params;
    }

    @Override
    public Object build(Grammar g) {
        try {
            Constructor<?>[] constructors = this.matcherClass.getConstructors();
            Preconditions.checkState((constructors.length == 1 ? 1 : 0) != 0, (Object)("The matcher class has " + constructors.length + " constructors, but 1 expected: " + this.matcherClass.getName()));
            Constructor<?> constructor = constructors[0];
            if (this.isLexerlessArrayOfMatchers(constructor)) {
                Object[] actualArguments = this.getActualArguments(g, this.arguments);
                Matcher[] actualMatcherArguments = new Matcher[actualArguments.length];
                System.arraycopy(actualArguments, 0, actualMatcherArguments, 0, actualMatcherArguments.length);
                Matcher[] actualMatcherArgument = actualMatcherArguments;
                return constructor.newInstance(new Object[]{actualMatcherArgument});
            }
            if (this.isLexerfulArrayOfMatchers(constructor)) {
                Object[] actualArguments = this.getActualArguments(g, this.arguments);
                com.sonar.sslr.impl.matcher.Matcher[] actualMatcherArguments = new com.sonar.sslr.impl.matcher.Matcher[actualArguments.length];
                System.arraycopy(actualArguments, 0, actualMatcherArguments, 0, actualMatcherArguments.length);
                com.sonar.sslr.impl.matcher.Matcher[] actualMatcherArgument = actualMatcherArguments;
                return constructor.newInstance(new Object[]{actualMatcherArgument});
            }
            return constructor.newInstance(this.getActualArguments(g, this.arguments));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isLexerlessArrayOfMatchers(Constructor constructor) {
        Class<?>[] parameters = constructor.getParameterTypes();
        return parameters.length == 1 && parameters[0].equals(Matcher[].class);
    }

    private boolean isLexerfulArrayOfMatchers(Constructor constructor) {
        Class<?>[] parameters = constructor.getParameterTypes();
        return parameters.length == 1 && parameters[0].equals(com.sonar.sslr.impl.matcher.Matcher[].class);
    }

    private Object[] getActualArguments(Grammar g, Object[] arguments) {
        Object[] actualArguments = new Object[arguments.length];
        for (int i = 0; i < actualArguments.length; ++i) {
            actualArguments[i] = this.getActualArgument(g, arguments[i]);
        }
        return actualArguments;
    }

    public Object getActualArgument(Grammar g, Object argument) {
        if (argument instanceof MatcherBuilder) {
            Object o = ((MatcherBuilder)argument).build(g);
            return o instanceof RuleDefinition ? ((RuleDefinition)o).getRule() : o;
        }
        return argument;
    }
}

