/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.MatchHandler;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.MatcherContext;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.matchers.ParserRuntimeException;

public class BasicMatcherContext
extends MatcherContext {
    private BasicMatcherContext parent;
    private BasicMatcherContext subContext;
    private ParseNode node;
    private final List<ParseNode> subNodes = Lists.newArrayList();

    public BasicMatcherContext(InputBuffer inputBuffer, MatchHandler matchHandler, Matcher matcher) {
        super(inputBuffer, matchHandler);
        this.parent = null;
        this.matcher = matcher;
    }

    public BasicMatcherContext(BasicMatcherContext parent) {
        super(parent.inputBuffer, parent.getMatchHandler());
        this.parent = parent;
    }

    public MatcherContext getSubContext(Matcher matcher) {
        if (this.subContext == null) {
            this.subContext = new BasicMatcherContext(this);
        }
        this.subContext.inputBuffer = this.inputBuffer;
        this.subContext.matcher = matcher;
        this.subContext.startIndex = this.currentIndex;
        this.subContext.currentIndex = this.currentIndex;
        this.subContext.node = null;
        this.subContext.ignoreErrors = this.ignoreErrors;
        return this.subContext;
    }

    public void retire() {
        super.retire();
        this.subNodes.clear();
    }

    public boolean runMatcher() {
        try {
            if (this.matcher.match(this)) {
                if (this.parent != null) {
                    this.parent.currentIndex = this.currentIndex;
                }
                this.retire();
                return true;
            }
            this.retire();
            return false;
        }
        catch (ParserRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParserRuntimeException(e);
        }
    }

    public void createNode() {
        this.node = new ParseNode(this.startIndex, this.currentIndex, this.subNodes, this.matcher);
        if (this.parent != null) {
            this.parent.subNodes.add(this.node);
        }
    }

    public void createNode(ParseNode node) {
        this.node = node;
        if (this.parent != null) {
            this.parent.subNodes.add(node);
        }
    }

    public void skipNode() {
        if (!this.subNodes.isEmpty()) {
            this.parent.subNodes.addAll(this.subNodes);
        }
    }

    public ParseNode getNode() {
        return this.node;
    }

    public BasicMatcherContext getParent() {
        return this.parent;
    }
}

