/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.sslr.internal.matchers.BasicMatcherContext;
import org.sonar.sslr.internal.matchers.GrammarElementMatcher;
import org.sonar.sslr.internal.matchers.MatchHandler;
import org.sonar.sslr.internal.matchers.MatcherContext;
import org.sonar.sslr.internal.matchers.MatcherPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingHandler
implements MatchHandler {
    private final MatchHandler delegate;
    private final int errorIndex;
    private final List<List<MatcherPathElement>> failedPaths = Lists.newArrayList();

    public ErrorReportingHandler(MatchHandler delegate, int errorIndex) {
        this.delegate = delegate;
        this.errorIndex = errorIndex;
    }

    @Override
    public boolean match(MatcherContext context) {
        return this.delegate.match(context);
    }

    @Override
    public void onMatch(MatcherContext context) {
        this.delegate.onMatch(context);
    }

    @Override
    public void onMissmatch(MatcherContext context) {
        List<MatcherPathElement> path;
        this.delegate.onMissmatch(context);
        if (this.errorIndex == context.getCurrentIndex() && !context.isIgnoreErrors() && this.isNewPath(path = ErrorReportingHandler.getPath((BasicMatcherContext)context))) {
            this.failedPaths.add(path);
        }
    }

    private static List<MatcherPathElement> getPath(BasicMatcherContext context) {
        ArrayList list = Lists.newArrayList();
        int endIndex = context.getCurrentIndex();
        while (context != null) {
            if (context.getMatcher() instanceof GrammarElementMatcher) {
                list.add(new MatcherPathElement(context.getMatcher(), context.getStartIndex(), endIndex));
                endIndex = context.getStartIndex();
            }
            context = context.getParent();
        }
        return ImmutableList.copyOf((Collection)Lists.reverse((List)list));
    }

    private boolean isNewPath(List<MatcherPathElement> path) {
        for (List old : Lists.reverse(this.failedPaths)) {
            if (!ErrorReportingHandler.isPrefix(path, old)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrefix(List<MatcherPathElement> first, List<MatcherPathElement> second) {
        if (first.size() > second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<List<MatcherPathElement>> getFailedPaths() {
        return this.failedPaths;
    }
}

