/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.ast.AlwaysSkipFromAst;
import com.sonar.sslr.impl.ast.NeverSkipFromAst;
import com.sonar.sslr.impl.ast.SkipFromAstIfOnlyOneChild;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.internal.matchers.EndOfInputMatcher;
import org.sonar.sslr.internal.matchers.FirstOfMatcher;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.MatcherContext;
import org.sonar.sslr.internal.matchers.MatchersUtils;
import org.sonar.sslr.internal.matchers.PatternMatcher;

public class GrammarElementMatcher
implements Rule,
Matcher,
AstNodeSkippingPolicy {
    private final String name;
    private final AstNodeType astNodeType;
    private Matcher[] subMatchers;
    private AstNodeSkippingPolicy astNodeSkippingPolicy = new NeverSkipFromAst();

    public GrammarElementMatcher(String name) {
        this.name = name;
        this.astNodeType = this;
    }

    public GrammarElementMatcher(String name, AstNodeType astNodeType) {
        this.name = name;
        this.astNodeType = astNodeType;
    }

    public GrammarElementMatcher is(Object ... elements) {
        if (this.subMatchers != null) {
            throw new IllegalStateException("The rule '" + this.name + "' has already been defined somewhere in the grammar.");
        }
        this.setSubMatchers(elements);
        return this;
    }

    public GrammarElementMatcher override(Object ... elements) {
        this.setSubMatchers(elements);
        return this;
    }

    public void mock() {
        this.setSubMatchers(this.getName(), new FirstOfMatcher(new PatternMatcher("\\s++"), new EndOfInputMatcher()));
    }

    private void setSubMatchers(Object ... elements) {
        this.subMatchers = MatchersUtils.convertToMatchers(elements);
    }

    public String getName() {
        return this.name;
    }

    public boolean match(MatcherContext context) {
        if (this.subMatchers == null) {
            throw new GrammarException("The rule '" + this.name + "' hasn't beed defined.");
        }
        if (context.getMatchHandler().match(context)) {
            return true;
        }
        for (Matcher subMatcher : this.subMatchers) {
            if (context.getSubContext(subMatcher).runMatcher()) continue;
            context.getMatchHandler().onMissmatch(context);
            return false;
        }
        context.createNode();
        context.getMatchHandler().onMatch(context);
        return true;
    }

    public void skip() {
        this.astNodeSkippingPolicy = new AlwaysSkipFromAst();
    }

    public void skipIfOneChild() {
        this.astNodeSkippingPolicy = new SkipFromAstIfOnlyOneChild();
    }

    public void skipIf(AstNodeSkippingPolicy policy) {
        this.astNodeSkippingPolicy = policy;
    }

    public void recoveryRule() {
        throw new UnsupportedOperationException();
    }

    public boolean hasToBeSkippedFromAst(AstNode node) {
        return this.astNodeSkippingPolicy.hasToBeSkippedFromAst(node);
    }

    public AstNodeType getRealAstNodeType() {
        return this.astNodeType;
    }
}

