/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.MatchHandler;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.ParseNode;

public abstract class MatcherContext
implements CharSequence {
    protected InputBuffer inputBuffer;
    protected int startIndex;
    protected int currentIndex;
    protected Matcher matcher;
    protected boolean ignoreErrors = false;
    private final MatchHandler matchHandler;

    public MatcherContext(InputBuffer inputBuffer, MatchHandler matchHandler) {
        this.inputBuffer = inputBuffer;
        this.matchHandler = matchHandler;
    }

    public abstract MatcherContext getSubContext(Matcher var1);

    public abstract void createNode();

    public abstract void createNode(ParseNode var1);

    public abstract void skipNode();

    public MatchHandler getMatchHandler() {
        return this.matchHandler;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public void retire() {
        this.matcher = null;
    }

    public void ignoreErrors() {
        this.ignoreErrors = true;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public abstract boolean runMatcher();

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void advanceIndex(int delta) {
        this.currentIndex += delta;
    }

    public void resetIndex() {
        this.currentIndex = this.startIndex;
    }

    public void setIndex(int index) {
        this.currentIndex = index;
    }

    public abstract ParseNode getNode();

    public int length() {
        return this.inputBuffer.length() - this.currentIndex;
    }

    public char charAt(int index) {
        return this.inputBuffer.charAt(this.currentIndex + index);
    }

    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

