/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.google.common.base.Preconditions;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.SequenceMatcher;
import org.sonar.sslr.internal.matchers.StringMatcher;

public final class MatchersUtils {
    private MatchersUtils() {
    }

    public static Matcher convertToSingleMatcher(Object ... elements) {
        Preconditions.checkNotNull((Object)elements);
        if (elements.length == 1) {
            return MatchersUtils.convertToMatcher(elements[0]);
        }
        return new SequenceMatcher(MatchersUtils.convertToMatchers(elements));
    }

    public static Matcher[] convertToMatchers(Object ... elements) {
        Preconditions.checkNotNull((Object)elements);
        Preconditions.checkArgument((elements.length > 0 ? 1 : 0) != 0);
        if (elements.length == 1 && elements[0] instanceof SequenceMatcher) {
            return ((SequenceMatcher)elements[0]).getSubMatchers();
        }
        Matcher[] matchers = new Matcher[elements.length];
        for (int i = 0; i < matchers.length; ++i) {
            matchers[i] = MatchersUtils.convertToMatcher(elements[i]);
        }
        return matchers;
    }

    public static Matcher convertToMatcher(Object element) {
        Preconditions.checkNotNull((Object)element);
        if (element instanceof Matcher) {
            return (Matcher)element;
        }
        if (element instanceof String) {
            return new StringMatcher((String)element);
        }
        if (element instanceof Character) {
            return new StringMatcher(Character.toString(((Character)element).charValue()));
        }
        throw new IllegalArgumentException("Incorrect type of parsing expression: " + element.getClass().getName());
    }
}

