/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.MatcherContext;

public class OneOrMoreMatcher
implements Matcher {
    private final Matcher subMatcher;

    public OneOrMoreMatcher(Matcher subMatcher) {
        this.subMatcher = subMatcher;
    }

    public boolean match(MatcherContext context) {
        if (!context.getSubContext(this.subMatcher).runMatcher()) {
            return false;
        }
        int previousIndex = context.getCurrentIndex();
        while (context.getSubContext(this.subMatcher).runMatcher()) {
            int currentIndex = context.getCurrentIndex();
            if (currentIndex == previousIndex) {
                throw new GrammarException("The inner part of OneOrMore must not allow empty matches");
            }
            previousIndex = currentIndex;
        }
        context.skipNode();
        return true;
    }
}

