/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import org.sonar.sslr.internal.matchers.EndOfInputMatcher;
import org.sonar.sslr.internal.matchers.FirstOfMatcher;
import org.sonar.sslr.internal.matchers.MatchersUtils;
import org.sonar.sslr.internal.matchers.NothingMatcher;
import org.sonar.sslr.internal.matchers.OneOrMoreMatcher;
import org.sonar.sslr.internal.matchers.OptionalMatcher;
import org.sonar.sslr.internal.matchers.PatternMatcher;
import org.sonar.sslr.internal.matchers.TestMatcher;
import org.sonar.sslr.internal.matchers.TestNotMatcher;
import org.sonar.sslr.internal.matchers.TokenMatcher;
import org.sonar.sslr.internal.matchers.TriviaMatcher;
import org.sonar.sslr.internal.matchers.ZeroOrMoreMatcher;

public final class GrammarOperators {
    private GrammarOperators() {
    }

    public static Object sequence(Object ... elements) {
        return MatchersUtils.convertToSingleMatcher(elements);
    }

    public static Object firstOf(Object ... elements) {
        Preconditions.checkNotNull((Object)elements);
        if (elements.length == 1) {
            return MatchersUtils.convertToMatcher(elements[0]);
        }
        return new FirstOfMatcher(MatchersUtils.convertToMatchers(elements));
    }

    public static Object optional(Object ... elements) {
        return new OptionalMatcher(MatchersUtils.convertToSingleMatcher(elements));
    }

    public static Object oneOrMore(Object ... elements) {
        return new OneOrMoreMatcher(MatchersUtils.convertToSingleMatcher(elements));
    }

    public static Object zeroOrMore(Object ... elements) {
        return new ZeroOrMoreMatcher(MatchersUtils.convertToSingleMatcher(elements));
    }

    public static Object next(Object ... elements) {
        return new TestMatcher(MatchersUtils.convertToSingleMatcher(elements));
    }

    public static Object nextNot(Object ... elements) {
        return new TestNotMatcher(MatchersUtils.convertToSingleMatcher(elements));
    }

    public static Object regexp(String regexp) {
        return new PatternMatcher(regexp);
    }

    public static Object endOfInput() {
        return new EndOfInputMatcher();
    }

    public static Object nothing() {
        return new NothingMatcher();
    }

    public static Object token(TokenType tokenType, Object element) {
        return new TokenMatcher(tokenType, MatchersUtils.convertToMatcher(element));
    }

    public static Object commentTrivia(Object element) {
        return new TriviaMatcher(Trivia.TriviaKind.COMMENT, MatchersUtils.convertToMatcher(element));
    }

    public static Object skippedTrivia(Object element) {
        return new TriviaMatcher(Trivia.TriviaKind.SKIPPED_TEXT, MatchersUtils.convertToMatcher(element));
    }
}

