/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sonar.sslr.api.Rule;
import java.util.List;
import org.sonar.sslr.internal.matchers.BasicMatcherContext;
import org.sonar.sslr.internal.matchers.ErrorLocatingHandler;
import org.sonar.sslr.internal.matchers.ErrorReportingHandler;
import org.sonar.sslr.internal.matchers.GrammarElementMatcher;
import org.sonar.sslr.internal.matchers.ImmutableInputBuffer;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.MatcherContext;
import org.sonar.sslr.internal.matchers.MatcherPathElement;
import org.sonar.sslr.internal.matchers.Memoizer;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParsingResult;

public class ParseRunner {
    private final Matcher rootMatcher;

    public ParseRunner(Rule rule) {
        this.rootMatcher = (Matcher)Preconditions.checkNotNull((Object)rule, (Object)"rule");
    }

    public ParsingResult parse(char[] input) {
        ImmutableInputBuffer inputBuffer = new ImmutableInputBuffer(input);
        Memoizer memoizer = new Memoizer(input.length);
        ErrorLocatingHandler errorLocatingHandler = new ErrorLocatingHandler(memoizer);
        BasicMatcherContext matcherContext = new BasicMatcherContext(inputBuffer, errorLocatingHandler, this.rootMatcher);
        boolean matched = ((MatcherContext)matcherContext).runMatcher();
        if (matched) {
            return new ParsingResult(inputBuffer, matched, ((MatcherContext)matcherContext).getNode(), null);
        }
        memoizer = new Memoizer(input.length);
        ErrorReportingHandler errorReportingHandler = new ErrorReportingHandler(memoizer, errorLocatingHandler.getErrorIndex());
        matched = new BasicMatcherContext(inputBuffer, errorReportingHandler, this.rootMatcher).runMatcher();
        Preconditions.checkState((!matched ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder("failed to match");
        if (errorReportingHandler.getFailedPaths().size() > 1) {
            sb.append(" all of");
        }
        sb.append(':');
        for (List<MatcherPathElement> failedPath : errorReportingHandler.getFailedPaths()) {
            Matcher failedMatcher = ((MatcherPathElement)Iterables.getLast(failedPath)).getMatcher();
            sb.append(' ').append(((GrammarElementMatcher)failedMatcher).getName());
        }
        ParseError parseError = new ParseError(inputBuffer, errorLocatingHandler.getErrorIndex(), sb.toString(), errorReportingHandler.getFailedPaths());
        return new ParsingResult(inputBuffer, matched, null, parseError);
    }
}

