/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.sslr.internal.matchers.AstCreator;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.text.AbstractText;
import org.sonar.sslr.internal.text.LocatedText;
import org.sonar.sslr.parser.LexerlessGrammar;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;
import org.sonar.sslr.text.PreprocessorsChain;
import org.sonar.sslr.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserAdapter<G extends LexerlessGrammar>
extends Parser<G> {
    private final Charset charset;
    private final ParseRunner parseRunner;
    private PreprocessorsChain preprocessorsChain;

    public ParserAdapter(Charset charset, G grammar) {
        this(charset, grammar, null);
    }

    public ParserAdapter(Charset charset, G grammar, @Nullable PreprocessorsChain preprocessorsChain) {
        super((Grammar)Preconditions.checkNotNull(grammar, (Object)"grammar"));
        this.charset = (Charset)Preconditions.checkNotNull((Object)charset, (Object)"charset");
        this.parseRunner = new ParseRunner(((Grammar)grammar).getRootRule());
        this.preprocessorsChain = preprocessorsChain;
    }

    @Override
    public AstNode parse(String source) {
        LocatedText text = new LocatedText(null, source.toCharArray());
        return this.parse(text);
    }

    @Override
    public AstNode parse(File file) {
        LocatedText text = new LocatedText(file, ParserAdapter.fileToCharArray(file, this.charset));
        return this.parse(text);
    }

    private static char[] fileToCharArray(File file, Charset charset) {
        char[] cArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            cArray = IOUtils.toCharArray((InputStream)is, (String)charset.name());
        }
        catch (IOException e) {
            try {
                throw new RecognitionException(0, e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return cArray;
    }

    private AstNode parse(Text input) {
        char[] chars;
        ParsingResult result;
        if (this.preprocessorsChain != null) {
            input = this.preprocessorsChain.process(input);
        }
        if ((result = this.parseRunner.parse(chars = ((AbstractText)input).toChars())).isMatched()) {
            AstNode astNode = AstCreator.create(result, input);
            astNode.hasToBeSkippedFromAst();
            return astNode;
        }
        ParseError parseError = result.getParseError();
        InputBuffer inputBuffer = parseError.getInputBuffer();
        int line = inputBuffer.getPosition(parseError.getErrorIndex()).getLine();
        String message = new ParseErrorFormatter().format(parseError);
        throw new RecognitionException(line, message);
    }

    @Override
    public AstNode parse(List<Token> tokens) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RuleDefinition getRootRule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParsingState getParsingState() {
        throw new UnsupportedOperationException();
    }
}

