/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.text;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;

public class TextLocation {
    private final File file;
    private final URI uri;
    private final int line;
    private final int column;

    public TextLocation(@Nullable File file, int line, int column) {
        this(file, file == null ? null : file.toURI(), line, column);
    }

    public TextLocation(@Nullable File file, @Nullable URI uri, int line, int column) {
        this.file = file;
        this.uri = uri;
        this.line = line;
        this.column = column;
    }

    public File getFile() {
        return this.file;
    }

    public URI getFileURI() {
        return this.uri;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.file, this.line, this.column});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TextLocation) {
            TextLocation other = (TextLocation)obj;
            return Objects.equal((Object)this.file, (Object)other.file) && this.line == other.line && this.column == other.column;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("file", (Object)this.file).add("line", (Object)this.line).add("column", (Object)this.column).toString();
    }
}

