/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.RecognitionExceptionListener;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.LexerException;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.util.List;
import org.sonar.sslr.internal.matchers.LexerfulAstCreator;
import org.sonar.sslr.internal.vm.CompiledGrammar;
import org.sonar.sslr.internal.vm.Machine;
import org.sonar.sslr.internal.vm.MutableGrammarCompiler;
import org.sonar.sslr.parser.ParserAdapter;

public class Parser<G extends Grammar> {
    private RuleDefinition rootRule;
    private final Lexer lexer;
    private final G grammar;

    protected Parser(G grammar) {
        this.grammar = grammar;
        this.lexer = null;
    }

    private Parser(Builder<G> builder) {
        this.lexer = ((Builder)builder).lexer;
        this.grammar = ((Builder)builder).grammar;
        this.rootRule = (RuleDefinition)((Grammar)this.grammar).getRootRule();
    }

    public AstNode parse(File file) {
        try {
            this.lexer.lex(file);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(String source) {
        try {
            this.lexer.lex(source);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(List<Token> tokens) {
        CompiledGrammar g = MutableGrammarCompiler.compile(this.rootRule);
        return LexerfulAstCreator.create(Machine.parse(tokens, g), tokens);
    }

    public G getGrammar() {
        return this.grammar;
    }

    public RuleDefinition getRootRule() {
        return this.rootRule;
    }

    public void setRootRule(Rule rootRule) {
        this.rootRule = (RuleDefinition)rootRule;
    }

    public static <G extends Grammar> Builder<G> builder(G grammar) {
        return new Builder(grammar, null);
    }

    public static <G extends Grammar> Builder<G> builder(Parser<G> parser) {
        return new Builder(parser);
    }

    public static final class Builder<G extends Grammar> {
        private Parser<G> baseParser;
        private Lexer lexer;
        private final G grammar;

        private Builder(G grammar) {
            this.grammar = grammar;
        }

        private Builder(Parser<G> parser) {
            this.baseParser = parser;
            this.lexer = ((Parser)parser).lexer;
            this.grammar = ((Parser)parser).grammar;
        }

        public Parser<G> build() {
            if (this.baseParser instanceof ParserAdapter) {
                return this.baseParser;
            }
            return new Parser(this);
        }

        public Builder<G> withLexer(Lexer lexer) {
            this.lexer = lexer;
            return this;
        }

        @Deprecated
        public Builder<G> setParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            return this;
        }

        @Deprecated
        public Builder<G> addParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            return this;
        }

        @Deprecated
        public Builder<G> setRecognictionExceptionListener(RecognitionExceptionListener ... listeners) {
            return this;
        }

        @Deprecated
        public Builder<G> addRecognictionExceptionListeners(RecognitionExceptionListener ... listeners) {
            return this;
        }

        @Deprecated
        public Builder<G> setExtendedStackTrace(ExtendedStackTrace extendedStackTrace) {
            return this;
        }

        /* synthetic */ Builder(Grammar x0, 1 x1) {
            this(x0);
        }
    }
}

