/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.grammar;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarBuilder;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableGrammar;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.NextNotExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;
import org.sonar.sslr.internal.vm.ZeroOrMoreExpression;
import org.sonar.sslr.internal.vm.lexerful.AdjacentExpression;
import org.sonar.sslr.internal.vm.lexerful.AnyTokenExpression;
import org.sonar.sslr.internal.vm.lexerful.TillNewLineExpression;
import org.sonar.sslr.internal.vm.lexerful.TokenTypeClassExpression;
import org.sonar.sslr.internal.vm.lexerful.TokenTypeExpression;
import org.sonar.sslr.internal.vm.lexerful.TokenTypesExpression;
import org.sonar.sslr.internal.vm.lexerful.TokenValueExpression;
import org.sonar.sslr.internal.vm.lexerful.TokensBridgeExpression;

public class LexerfulGrammarBuilder
extends GrammarBuilder {
    private final Map<GrammarRuleKey, RuleDefinition> definitions = Maps.newHashMap();
    private GrammarRuleKey rootRuleKey;

    public static LexerfulGrammarBuilder create() {
        return new LexerfulGrammarBuilder(new LexerfulGrammarBuilder[0]);
    }

    public static LexerfulGrammarBuilder createBasedOn(LexerfulGrammarBuilder ... base) {
        return new LexerfulGrammarBuilder(base);
    }

    private LexerfulGrammarBuilder(LexerfulGrammarBuilder ... base) {
        for (LexerfulGrammarBuilder b : base) {
            this.definitions.putAll(b.definitions);
        }
    }

    @Override
    public GrammarRuleBuilder rule(GrammarRuleKey ruleKey) {
        RuleDefinition rule = this.definitions.get(ruleKey);
        if (rule == null) {
            rule = new RuleDefinition(ruleKey);
            this.definitions.put(ruleKey, rule);
        }
        return new GrammarBuilder.RuleBuilder(this, rule);
    }

    @Override
    public void setRootRule(GrammarRuleKey ruleKey) {
        this.rule(ruleKey);
        this.rootRuleKey = ruleKey;
    }

    public Grammar build() {
        for (RuleDefinition rule : this.definitions.values()) {
            if (rule.getExpression() != null) continue;
            throw new GrammarException("The rule '" + rule.getRuleKey() + "' hasn't beed defined.");
        }
        return new MutableGrammar(this.definitions, this.rootRuleKey);
    }

    public Grammar buildWithMemoizationOfMatchesForAllRules() {
        for (RuleDefinition rule : this.definitions.values()) {
            rule.enableMemoization();
        }
        return this.build();
    }

    public Object adjacent(Object e) {
        return new SequenceExpression(AdjacentExpression.INSTANCE, this.convertToExpression(e));
    }

    public Object anyTokenButNot(Object e) {
        return new SequenceExpression(new NextNotExpression(this.convertToExpression(e)), AnyTokenExpression.INSTANCE);
    }

    public Object isOneOfThem(TokenType t1, TokenType ... rest) {
        TokenType[] types = new TokenType[1 + rest.length];
        types[0] = t1;
        System.arraycopy(rest, 0, types, 1, rest.length);
        return new TokenTypesExpression(types);
    }

    public Object bridge(TokenType from, TokenType to) {
        return new TokensBridgeExpression(from, to);
    }

    @Deprecated
    public Object everything() {
        return AnyTokenExpression.INSTANCE;
    }

    public Object anyToken() {
        return AnyTokenExpression.INSTANCE;
    }

    public Object tillNewLine() {
        return TillNewLineExpression.INSTANCE;
    }

    public Object till(Object e) {
        ParsingExpression expression = this.convertToExpression(e);
        return new SequenceExpression(new ZeroOrMoreExpression(new SequenceExpression(new NextNotExpression(expression), AnyTokenExpression.INSTANCE)), expression);
    }

    public Object exclusiveTill(Object e) {
        return new ZeroOrMoreExpression(new SequenceExpression(new NextNotExpression(this.convertToExpression(e)), AnyTokenExpression.INSTANCE));
    }

    public Object exclusiveTill(Object e1, Object ... rest) {
        return this.exclusiveTill(new FirstOfExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    @Override
    protected ParsingExpression convertToExpression(Object e) {
        ParsingExpression result;
        Preconditions.checkNotNull((Object)e, (Object)"Parsing expression can't be null");
        if (e instanceof ParsingExpression) {
            result = (ParsingExpression)e;
        } else if (e instanceof GrammarRuleKey) {
            GrammarRuleKey ruleKey = (GrammarRuleKey)e;
            this.rule(ruleKey);
            result = this.definitions.get(ruleKey);
        } else if (e instanceof TokenType) {
            result = new TokenTypeExpression((TokenType)e);
        } else if (e instanceof String) {
            result = new TokenValueExpression((String)e);
        } else if (e instanceof Class) {
            result = new TokenTypeClassExpression((Class)e);
        } else {
            throw new IllegalArgumentException("Incorrect type of parsing expression: " + e.getClass().toString());
        }
        return result;
    }
}

