/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.grammar;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarBuilder;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableGrammar;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.vm.EndOfInputExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.PatternExpression;
import org.sonar.sslr.internal.vm.StringExpression;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;
import org.sonar.sslr.parser.LexerlessGrammar;

public class LexerlessGrammarBuilder
extends GrammarBuilder {
    private final Map<GrammarRuleKey, MutableParsingRule> definitions = Maps.newHashMap();
    private GrammarRuleKey rootRuleKey;

    public static LexerlessGrammarBuilder create() {
        return new LexerlessGrammarBuilder(new LexerlessGrammarBuilder[0]);
    }

    public static LexerlessGrammarBuilder createBasedOn(LexerlessGrammarBuilder ... base) {
        return new LexerlessGrammarBuilder(base);
    }

    private LexerlessGrammarBuilder(LexerlessGrammarBuilder ... base) {
        for (LexerlessGrammarBuilder b : base) {
            this.definitions.putAll(b.definitions);
        }
    }

    @Override
    public GrammarRuleBuilder rule(GrammarRuleKey ruleKey) {
        MutableParsingRule rule = this.definitions.get(ruleKey);
        if (rule == null) {
            rule = new MutableParsingRule(ruleKey);
            this.definitions.put(ruleKey, rule);
        }
        return new GrammarBuilder.RuleBuilder(this, rule);
    }

    @Override
    public void setRootRule(GrammarRuleKey ruleKey) {
        this.rule(ruleKey);
        this.rootRuleKey = ruleKey;
    }

    public LexerlessGrammar build() {
        for (MutableParsingRule rule : this.definitions.values()) {
            if (rule.getExpression() != null) continue;
            throw new GrammarException("The rule '" + rule.getRuleKey() + "' hasn't beed defined.");
        }
        return new MutableGrammar(this.definitions, this.rootRuleKey);
    }

    public Object regexp(String regexp) {
        return new PatternExpression(regexp);
    }

    public Object endOfInput() {
        return EndOfInputExpression.INSTANCE;
    }

    public Object token(TokenType tokenType, Object e) {
        return new TokenExpression(tokenType, this.convertToExpression(e));
    }

    public Object commentTrivia(Object e) {
        return new TriviaExpression(Trivia.TriviaKind.COMMENT, this.convertToExpression(e));
    }

    public Object skippedTrivia(Object e) {
        return new TriviaExpression(Trivia.TriviaKind.SKIPPED_TEXT, this.convertToExpression(e));
    }

    @Override
    protected ParsingExpression convertToExpression(Object e) {
        ParsingExpression result;
        Preconditions.checkNotNull((Object)e, (Object)"Parsing expression can't be null");
        if (e instanceof ParsingExpression) {
            result = (ParsingExpression)e;
        } else if (e instanceof GrammarRuleKey) {
            GrammarRuleKey ruleKey = (GrammarRuleKey)e;
            this.rule(ruleKey);
            result = this.definitions.get(ruleKey);
        } else if (e instanceof String) {
            result = new StringExpression((String)e);
        } else if (e instanceof Character) {
            result = new StringExpression(((Character)e).toString());
        } else {
            throw new IllegalArgumentException("Incorrect type of parsing expression: " + e.getClass().toString());
        }
        return result;
    }
}

