/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.text.CompositeText;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;
import org.sonar.sslr.parser.ParsingResult;
import org.sonar.sslr.text.Text;
import org.sonar.sslr.text.TextCharSequence;
import org.sonar.sslr.text.TextLocation;

public final class AstCreator {
    private static final URI FAKE_URI;
    private final TextCharSequence input;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = Lists.newArrayList();
    @VisibleForTesting
    static final TokenType UNDEFINED_TOKEN_TYPE;

    public static AstNode create(ParsingResult parsingResult, Text input) {
        AstNode astNode = new AstCreator(input).visit(parsingResult.getParseTreeRoot());
        astNode.hasToBeSkippedFromAst();
        return astNode;
    }

    private AstCreator(Text input) {
        this.input = input.sequence();
    }

    private AstNode visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private AstNode visitTerminal(ParseNode node) {
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.updateTokenPositionAndValue(node);
                this.tokenBuilder.setTrivia(Collections.<Trivia>emptyList());
                this.tokenBuilder.setType(GenericTokenType.COMMENT);
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + (Object)((Object)ruleMatcher.getTriviaKind()));
        }
        if (node.getMatcher() instanceof TokenExpression) {
            this.updateTokenPositionAndValue(node);
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            this.tokenBuilder.setType(ruleMatcher.getTokenType());
            if (ruleMatcher.getTokenType() == GenericTokenType.COMMENT) {
                this.tokenBuilder.setTrivia(Collections.<Trivia>emptyList());
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
        } else {
            this.updateTokenPositionAndValue(node);
            this.tokenBuilder.setType(UNDEFINED_TOKEN_TYPE);
        }
        Token token = this.tokenBuilder.setTrivia(this.trivias).build();
        this.trivias.clear();
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private void updateTokenPositionAndValue(ParseNode node) {
        TextLocation location = this.input.getLocation(node.getStartIndex());
        if (location == null) {
            this.tokenBuilder.setGeneratedCode(true);
            this.tokenBuilder.setLine(1);
            this.tokenBuilder.setColumn(0);
            this.tokenBuilder.setURI(FAKE_URI);
        } else {
            TextLocation copyLocation;
            this.tokenBuilder.setGeneratedCode(false);
            this.tokenBuilder.setLine(location.getLine());
            this.tokenBuilder.setColumn(location.getColumn() - 1);
            this.tokenBuilder.setURI(location.getFileURI() == null ? FAKE_URI : location.getFileURI());
            TextLocation textLocation = copyLocation = this.input instanceof CompositeText.CompositeTextCharSequence ? ((CompositeText.CompositeTextCharSequence)this.input).getCopyLocation(node.getStartIndex()) : null;
            if (copyLocation == null) {
                this.tokenBuilder.notCopyBook();
            } else {
                this.tokenBuilder.setCopyBook(copyLocation.getFile().getAbsolutePath(), copyLocation.getLine());
            }
        }
        String value = this.getValue(node);
        this.tokenBuilder.setValueAndOriginalValue(value);
    }

    private AstNode visitNonTerminal(ParseNode node) {
        MutableParsingRule ruleMatcher = (MutableParsingRule)node.getMatcher();
        ArrayList astNodes = Lists.newArrayList();
        for (ParseNode child : node.getChildren()) {
            AstNode astNode = this.visit(child);
            if (astNode == null) continue;
            if (astNode.hasToBeSkippedFromAst()) {
                astNodes.addAll(astNode.getChildren());
                continue;
            }
            astNodes.add(astNode);
        }
        Token token = null;
        for (AstNode child : astNodes) {
            if (child.getToken() == null) continue;
            token = child.getToken();
            break;
        }
        AstNode astNode = new AstNode(ruleMatcher, ruleMatcher.getName(), token);
        for (AstNode child : astNodes) {
            astNode.addChild(child);
        }
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private String getValue(ParseNode node) {
        StringBuilder result = new StringBuilder();
        for (int i = node.getStartIndex(); i < Math.min(node.getEndIndex(), this.input.length()); ++i) {
            result.append(this.input.charAt(i));
        }
        return result.toString();
    }

    static {
        try {
            FAKE_URI = new URI("tests://unittest");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        UNDEFINED_TOKEN_TYPE = new TokenType(){

            @Override
            public String getName() {
                return "TOKEN";
            }

            @Override
            public String getValue() {
                return this.getName();
            }

            @Override
            public boolean hasToBeSkippedFromAst(AstNode node) {
                return false;
            }
        };
    }
}

