/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.text;

import java.util.List;
import org.sonar.sslr.internal.text.AbstractText;
import org.sonar.sslr.internal.text.SubText;
import org.sonar.sslr.internal.text.TransformedText;
import org.sonar.sslr.text.Text;
import org.sonar.sslr.text.TextCharSequence;
import org.sonar.sslr.text.TextLocation;

public class CompositeText
extends AbstractText {
    private final int transformationDepth;
    private final AbstractText[] texts;
    private final int length;

    public CompositeText(List<AbstractText> texts) {
        this.texts = texts.toArray(new AbstractText[texts.size()]);
        int len = 0;
        int depth = 0;
        for (AbstractText text : this.texts) {
            len += text.length();
            depth = Math.max(depth, text.getTransformationDepth());
        }
        this.length = len;
        this.transformationDepth = depth;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void toCharArray(int srcPos, char[] dest, int destPos, int length) {
        int toText;
        CompositeTextCharSequence sequence = (CompositeTextCharSequence)this.sequence();
        sequence.moveTo(srcPos);
        int skipped = sequence.skipped;
        int fromText = sequence.textIndex;
        if (srcPos + length < this.length) {
            sequence.moveTo(srcPos + length);
            toText = sequence.textIndex;
        } else {
            toText = this.texts.length - 1;
        }
        if (fromText == toText) {
            this.texts[toText].toCharArray(srcPos - skipped, dest, destPos, length);
        } else {
            int startPos = srcPos - skipped;
            this.texts[fromText].toCharArray(startPos, dest, destPos, this.texts[fromText].length() - startPos);
            destPos += this.texts[fromText].length() - startPos;
            skipped += this.texts[fromText].length();
            for (int i = fromText + 1; i <= toText - 1; ++i) {
                this.texts[i].toCharArray(0, dest, destPos, this.texts[i].length());
                destPos += this.texts[i].length();
                skipped += this.texts[i].length();
            }
            this.texts[toText].toCharArray(0, dest, destPos, srcPos + length - skipped);
        }
    }

    @Override
    protected int getTransformationDepth() {
        return this.transformationDepth;
    }

    @Override
    public TextCharSequence sequence() {
        return new CompositeTextCharSequence();
    }

    public class CompositeTextCharSequence
    implements TextCharSequence {
        private int skipped = 0;
        private int index = 0;
        private int textIndex = 0;
        private TextCharSequence innerSequence = CompositeText.access$300(CompositeText.this)[this.textIndex].sequence();

        @Override
        public Text getText() {
            return CompositeText.this;
        }

        @Override
        public int length() {
            return CompositeText.this.length;
        }

        private int getInnerIndex(int index) {
            return index - this.skipped;
        }

        @Override
        public char charAt(int index) {
            this.moveTo(index);
            return this.innerSequence.charAt(this.getInnerIndex(index));
        }

        @Override
        public TextCharSequence subSequence(int start, int end) {
            return this.subText(start, end).sequence();
        }

        @Override
        public Text subText(int start, int end) {
            return new SubText(CompositeText.this, start, end);
        }

        @Override
        public TextLocation getLocation(int index) {
            this.moveTo(index);
            return this.innerSequence.getLocation(this.getInnerIndex(index));
        }

        private void moveTo(int index) {
            if (this.index == index) {
                return;
            }
            if (this.skipped > index || index >= this.skipped + CompositeText.this.texts[this.textIndex].length()) {
                if (index == CompositeText.this.length) {
                    this.textIndex = CompositeText.this.texts.length - 1;
                    this.skipped = CompositeText.this.length - CompositeText.this.texts[this.textIndex].length();
                } else if (index > this.index) {
                    while (this.skipped + CompositeText.this.texts[this.textIndex].length() <= index) {
                        this.skipped += CompositeText.this.texts[this.textIndex].length();
                        ++this.textIndex;
                    }
                } else {
                    while (index < this.skipped) {
                        this.skipped -= CompositeText.this.texts[this.textIndex].length();
                        --this.textIndex;
                    }
                }
                this.innerSequence = CompositeText.this.texts[this.textIndex].sequence();
            }
            this.index = index;
        }

        public TextLocation getCopyLocation(int index) {
            this.moveTo(index);
            return CompositeText.this.texts[this.textIndex] instanceof TransformedText ? ((TransformedText)CompositeText.this.texts[this.textIndex]).getTransformedText().sequence().getLocation(0) : null;
        }

        @Override
        public String toString() {
            return this.getText().toString();
        }
    }
}

