/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm.lexerful;

import com.sonar.sslr.api.Token;
import java.util.List;

public class LexerfulParseErrorFormatter {
    private static final int SNIPPET_SIZE = 30;

    public String format(List<Token> tokens, int errorIndex) {
        StringBuilder sb = new StringBuilder();
        Pos errorPos = errorIndex < tokens.size() ? LexerfulParseErrorFormatter.getTokenStart(tokens.get(errorIndex)) : LexerfulParseErrorFormatter.getTokenEnd(tokens.get(tokens.size() - 1));
        sb.append("Parse error at line ").append(errorPos.line).append(" column ").append(errorPos.column).append(":\n\n");
        LexerfulParseErrorFormatter.appendSnippet(sb, tokens, errorIndex, errorPos.line);
        return sb.toString();
    }

    private static Pos getTokenStart(Token token) {
        Pos pos = new Pos();
        pos.line = token.getLine();
        pos.column = token.getColumn();
        return pos;
    }

    private static Pos getTokenEnd(Token token) {
        Pos pos = new Pos();
        pos.line = token.getLine();
        pos.column = token.getColumn();
        String[] tokenLines = token.getOriginalValue().split("(\r)?\n|\r", -1);
        if (tokenLines.length == 1) {
            pos.column += tokenLines[0].length();
        } else {
            pos.line += tokenLines.length - 1;
            pos.column = tokenLines[tokenLines.length - 1].length();
        }
        return pos;
    }

    private static void appendSnippet(StringBuilder sb, List<Token> tokens, int errorIndex, int errorLine) {
        int startToken = Math.max(errorIndex - 30, 0);
        int endToken = Math.min(errorIndex + 30, tokens.size());
        tokens = tokens.subList(startToken, endToken);
        int line = tokens.get(0).getLine();
        int column = tokens.get(0).getColumn();
        sb.append(LexerfulParseErrorFormatter.formatLineNumber(line, errorLine));
        for (Token token : tokens) {
            while (line < token.getLine()) {
                column = 0;
                sb.append('\n').append(LexerfulParseErrorFormatter.formatLineNumber(++line, errorLine));
            }
            while (column < token.getColumn()) {
                sb.append(' ');
                ++column;
            }
            String[] tokenLines = token.getOriginalValue().split("(\r)?\n|\r", -1);
            sb.append(tokenLines[0]);
            column += tokenLines[0].length();
            for (int j = 1; j < tokenLines.length; ++j) {
                sb.append('\n').append(LexerfulParseErrorFormatter.formatLineNumber(++line, errorLine)).append(tokenLines[j]);
                column = tokenLines[j].length();
            }
        }
        sb.append('\n');
    }

    private static String formatLineNumber(int line, int errorLine) {
        return line == errorLine ? String.format("%1$5s  ", "-->") : String.format("%1$5d: ", line);
    }

    private static class Pos {
        int line;
        int column;

        private Pos() {
        }

        public String toString() {
            return "(" + this.line + ", " + this.column + ")";
        }
    }
}

