/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.TextUtils;
import org.sonar.sslr.parser.ParseError;

public class ParseErrorFormatter {
    private static final int SNIPPET_SIZE = 10;

    public String format(ParseError parseError) {
        Preconditions.checkNotNull((Object)parseError);
        InputBuffer inputBuffer = parseError.getInputBuffer();
        InputBuffer.Position position = inputBuffer.getPosition(parseError.getErrorIndex());
        StringBuilder sb = new StringBuilder();
        sb.append("Parse error at line ").append(position.getLine()).append(" column ").append(position.getColumn()).append(":\n\n");
        ParseErrorFormatter.appendSnippet(sb, inputBuffer, position);
        return sb.toString();
    }

    private static void appendSnippet(StringBuilder sb, InputBuffer inputBuffer, InputBuffer.Position position) {
        int startLine = Math.max(position.getLine() - 10, 1);
        int endLine = Math.min(position.getLine() + 10, inputBuffer.getLineCount());
        int padding = Integer.toString(endLine).length();
        String lineNumberFormat = "%1$" + padding + "d: ";
        for (int line = startLine; line <= endLine; ++line) {
            sb.append(String.format(lineNumberFormat, line));
            sb.append(TextUtils.trimTrailingLineSeparatorFrom(inputBuffer.extractLine(line)).replace("\t", " ")).append('\n');
            if (line != position.getLine()) continue;
            for (int i = 1; i < position.getColumn() + padding + 2; ++i) {
                sb.append(' ');
            }
            sb.append("^\n");
        }
    }
}

