/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.basic.ArrayType;
import org.codehaus.xfire.aegis.type.collection.CollectionType;
import org.codehaus.xfire.aegis.type.collection.MapType;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.ServiceUtils;

public abstract class AbstractTypeCreator
implements TypeCreator {
    protected TypeMapping tm;
    protected AbstractTypeCreator nextCreator;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public void setNextCreator(AbstractTypeCreator creator) {
        this.nextCreator = creator;
    }

    protected TypeClassInfo createClassInfo(Field f) {
        return this.createBasicClassInfo(f.getType());
    }

    protected TypeClassInfo createBasicClassInfo(Class typeClass) {
        TypeClassInfo info = new TypeClassInfo();
        info.setTypeClass(typeClass);
        return info;
    }

    protected Type createTypeForClass(TypeClassInfo info) {
        Class javaType = info.getTypeClass();
        if (javaType.isArray()) {
            return this.createArrayType(info);
        }
        if (this.isMap(javaType)) {
            return this.createMapType(info);
        }
        if (this.isCollection(javaType)) {
            return this.createCollectionType(info);
        }
        if (this.isEnum(javaType)) {
            return this.createEnumType(info);
        }
        Type type = this.getTypeMapping().getType(javaType);
        if (type == null) {
            type = this.createDefaultType(info);
        }
        return type;
    }

    protected QName createArrayQName(Class javaType) {
        return this.createCollectionQName(javaType, javaType.getComponentType());
    }

    protected Type createArrayType(TypeClassInfo info) {
        ArrayType type = new ArrayType();
        type.setSchemaType(this.createArrayQName(info.getTypeClass()));
        type.setTypeClass(info.getTypeClass());
        return type;
    }

    protected QName createQName(Class javaType) {
        String clsName = javaType.getName();
        String ns = NamespaceHelper.makeNamespaceFromClassName((String)clsName, (String)"http");
        String localName = ServiceUtils.makeServiceNameFromClassName((Class)javaType);
        return new QName(ns, localName);
    }

    protected boolean isCollection(Class javaType) {
        return (class$java$util$Collection == null ? (class$java$util$Collection = AbstractTypeCreator.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(javaType);
    }

    protected Type createCollectionType(TypeClassInfo info, Class component) {
        CollectionType type = new CollectionType(component);
        type.setTypeMapping(this.getTypeMapping());
        QName name = info.getName();
        if (name == null) {
            name = this.createCollectionQName(info.getTypeClass(), component);
        }
        type.setSchemaType(name);
        type.setTypeClass(info.getTypeClass());
        return type;
    }

    protected Type createMapType(TypeClassInfo info) {
        QName schemaType = new QName(this.getTypeMapping().getEncodingStyleURI(), "map");
        MapType type = new MapType(schemaType, (Class)info.getKeyType(), (Class)info.getGenericType());
        type.setTypeMapping(this.getTypeMapping());
        type.setTypeClass(info.getTypeClass());
        return type;
    }

    protected boolean isMap(Class javaType) {
        return (class$java$util$Map == null ? (class$java$util$Map = AbstractTypeCreator.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(javaType);
    }

    public abstract TypeClassInfo createClassInfo(PropertyDescriptor var1);

    protected boolean isEnum(Class javaType) {
        return false;
    }

    public Type createEnumType(TypeClassInfo info) {
        return null;
    }

    public abstract Type createCollectionType(TypeClassInfo var1);

    public abstract Type createDefaultType(TypeClassInfo var1);

    protected QName createCollectionQName(Class javaType, Class componentType) {
        if (componentType == null) {
            throw new XFireRuntimeException("Cannot create mapping for " + javaType.getName() + ", unspecified component type");
        }
        Type type = this.tm.getType(componentType);
        if (type == null) {
            type = this.createType(componentType);
            this.getTypeMapping().register(type);
        }
        String ns = type.isComplex() ? type.getSchemaType().getNamespaceURI() : this.tm.getEncodingStyleURI();
        String first = type.getSchemaType().getLocalPart().substring(0, 1);
        String last = type.getSchemaType().getLocalPart().substring(1);
        String localName = "ArrayOf" + first.toUpperCase() + last;
        return new QName(ns, localName);
    }

    public abstract TypeClassInfo createClassInfo(Method var1, int var2);

    public Type createType(Method m, int index) {
        TypeClassInfo info = this.createClassInfo(m, index);
        return this.createTypeForClass(info);
    }

    public Type createType(PropertyDescriptor pd) {
        TypeClassInfo info = this.createClassInfo(pd);
        return this.createTypeForClass(info);
    }

    public Type createType(Field f) {
        TypeClassInfo info = this.createClassInfo(f);
        return this.createTypeForClass(info);
    }

    public Type createType(Class clazz) {
        TypeClassInfo info = this.createBasicClassInfo(clazz);
        return this.createTypeForClass(info);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TypeClassInfo {
        Class typeClass;
        Object[] annotations;
        Object genericType;
        Object keyType;
        QName name;

        public Object[] getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Object[] annotations) {
            this.annotations = annotations;
        }

        public Object getGenericType() {
            return this.genericType;
        }

        public void setGenericType(Object genericType) {
            this.genericType = genericType;
        }

        public Object getKeyType() {
            return this.keyType;
        }

        public void setKeyType(Object keyType) {
            this.keyType = keyType;
        }

        public Class getTypeClass() {
            return this.typeClass;
        }

        public void setTypeClass(Class typeClass) {
            this.typeClass = typeClass;
        }

        public QName getName() {
            return this.name;
        }

        public void setName(QName name) {
            this.name = name;
        }
    }
}

