/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.mtom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.activation.DataContentHandler;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.DefaultDataContentHandlerFactory;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.fault.XFireFault;

public abstract class XOPType
extends Type {
    public static final String XOP_NS = "http://www.w3.org/2004/08/xop/include";
    public static final String XML_MIME_NS = "http://www.w3.org/2004/11/xmlmime";
    private static DefaultDataContentHandlerFactory factory = new DefaultDataContentHandlerFactory();
    private Map classToCType;
    private Map CTypeToClass;

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        String uri = null;
        Object contentType = null;
        Attachment att = this.getAttachment(uri, context);
        String type = att.getDataHandler().getContentType();
        DataContentHandler handler = factory.createDataContentHandler(type);
        try {
            if (handler != null) {
                return handler.getContent(att.getDataHandler().getDataSource());
            }
            return att.getDataHandler().getContent();
        }
        catch (IOException e) {
            throw new XFireFault("Could not read the attachment " + uri, (Throwable)e, "Sender");
        }
    }

    protected String getURI(String value) {
        int index = value.indexOf(":");
        return value.substring(index + 1);
    }

    public Attachment getAttachment(String id, MessageContext context) throws XFireFault {
        Attachments attachments = (Attachments)context.getProperty((Object)"xfire.attachments");
        Attachment att = null;
        if (attachments != null) {
            att = attachments.getPart(id);
        }
        try {
            URLDataSource source = new URLDataSource(new URL(id));
            att = new SimpleAttachment(id, new DataHandler((DataSource)source));
        }
        catch (MalformedURLException e) {
            throw new XFireFault("Invalid attachment id: " + id, (Throwable)e, "Sender");
        }
        return att;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        throw new UnsupportedOperationException();
    }
}

