/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.yom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.aegis.AbstractMessageWriter;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.yom.AttributeWriter;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class YOMWriter
extends AbstractMessageWriter {
    private Element element;

    public YOMWriter(Element element) {
        this.element = element;
    }

    public void writeValue(Object value) {
        this.element.appendChild(value.toString());
    }

    public void writeValue(Object value, String ns, String attr) {
        this.element.addAttribute(new Attribute(attr, ns, value.toString()));
    }

    public MessageWriter getElementWriter(String name) {
        return this.getElementWriter(name, this.element.getNamespaceURI());
    }

    public MessageWriter getElementWriter(String name, String namespace) {
        String prefix = NamespaceHelper.getUniquePrefix((Element)this.element, (String)namespace);
        Element child = new Element(prefix + ":" + name, namespace);
        this.element.appendChild((Node)child);
        return new YOMWriter(child);
    }

    public MessageWriter getElementWriter(QName qname) {
        String name = qname.getLocalPart();
        if (qname.getPrefix().length() > 0) {
            name = qname.getPrefix() + ":" + name;
        } else {
            String prefix = NamespaceHelper.getUniquePrefix((Element)this.element, (String)qname.getNamespaceURI());
            name = prefix + ":" + name;
        }
        Element child = new Element(name, qname.getNamespaceURI());
        this.element.appendChild((Node)child);
        return new YOMWriter(child);
    }

    public XMLStreamWriter getXMLStreamWriter() {
        throw new UnsupportedOperationException("Stream writing not supported from a YOMWriter.");
    }

    public MessageWriter getAttributeWriter(String name) {
        Attribute att = new Attribute(this.element.getNamespacePrefix() + ":" + name, this.element.getNamespaceURI(), "");
        this.element.addAttribute(att);
        return new AttributeWriter(att);
    }

    public MessageWriter getAttributeWriter(String name, String namespace) {
        Attribute att = null;
        if (namespace != null && namespace.length() > 0) {
            String prefix = NamespaceHelper.getUniquePrefix((Element)this.element, (String)namespace);
            att = new Attribute(prefix + ":" + name, namespace, "");
        } else {
            att = new Attribute(name, "");
        }
        this.element.addAttribute(att);
        return new AttributeWriter(att);
    }

    public MessageWriter getAttributeWriter(QName qname) {
        return this.getAttributeWriter(qname.getLocalPart(), qname.getNamespaceURI());
    }

    public void close() {
    }
}

