/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.math.BigDecimal;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.CustomTypeMapping;
import org.codehaus.xfire.aegis.type.DefaultTypeCreator;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.aegis.type.XMLTypeCreator;
import org.codehaus.xfire.aegis.type.basic.Base64Type;
import org.codehaus.xfire.aegis.type.basic.BigDecimalType;
import org.codehaus.xfire.aegis.type.basic.BooleanType;
import org.codehaus.xfire.aegis.type.basic.CalendarType;
import org.codehaus.xfire.aegis.type.basic.DateTimeType;
import org.codehaus.xfire.aegis.type.basic.DoubleType;
import org.codehaus.xfire.aegis.type.basic.FloatType;
import org.codehaus.xfire.aegis.type.basic.IntType;
import org.codehaus.xfire.aegis.type.basic.LongType;
import org.codehaus.xfire.aegis.type.basic.ObjectType;
import org.codehaus.xfire.aegis.type.basic.ShortType;
import org.codehaus.xfire.aegis.type.basic.SqlDateType;
import org.codehaus.xfire.aegis.type.basic.StringType;
import org.codehaus.xfire.aegis.type.basic.TimeType;
import org.codehaus.xfire.aegis.type.basic.TimestampType;
import org.codehaus.xfire.aegis.type.basic.URIType;
import org.codehaus.xfire.aegis.type.xml.DocumentType;
import org.codehaus.xfire.aegis.type.xml.JDOMElementType;
import org.codehaus.xfire.aegis.type.xml.SourceType;
import org.codehaus.xfire.aegis.type.xml.XMLStreamReaderType;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.jdom.Element;
import org.w3c.dom.Document;

public class DefaultTypeMappingRegistry
implements TypeMappingRegistry {
    private static final Log logger = LogFactory.getLog((Class)DefaultTypeMappingRegistry.class);
    protected static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    protected static final QName XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd");
    protected static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd");
    protected static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd");
    protected static final QName XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd");
    protected static final QName XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd");
    protected static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd");
    protected static final QName XSD_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    protected static final QName XSD_TIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    protected static final QName XSD_BASE64 = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xsd");
    protected static final QName XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal", "xsd");
    protected static final QName XSD_URI = new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xsd");
    protected static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    protected static final String ENCODED_NS = Soap11.getInstance().getSoapEncodingStyle();
    protected static final QName ENCODED_STRING = new QName(ENCODED_NS, "string");
    protected static final QName ENCODED_LONG = new QName(ENCODED_NS, "long");
    protected static final QName ENCODED_FLOAT = new QName(ENCODED_NS, "float");
    protected static final QName ENCODED_DOUBLE = new QName(ENCODED_NS, "double");
    protected static final QName ENCODED_INT = new QName(ENCODED_NS, "int");
    protected static final QName ENCODED_SHORT = new QName(ENCODED_NS, "short");
    protected static final QName ENCODED_BOOLEAN = new QName(ENCODED_NS, "boolean");
    protected static final QName ENCODED_DATETIME = new QName(ENCODED_NS, "dateTime");
    protected static final QName ENCODED_BASE64 = new QName(ENCODED_NS, "base64Binary");
    protected static final QName ENCODED_DECIMAL = new QName(ENCODED_NS, "decimal");
    private Hashtable registry = new Hashtable();
    private TypeMapping defaultTM;
    private TypeCreator typeCreator;

    public DefaultTypeMappingRegistry() {
        this(false);
    }

    public DefaultTypeMappingRegistry(boolean createDefault) {
        this(null, createDefault);
    }

    public DefaultTypeMappingRegistry(TypeCreator typeCreator, boolean createDefault) {
        this.typeCreator = typeCreator;
        if (createDefault) {
            this.createDefaultMappings();
        }
    }

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        TypeMapping previous = (TypeMapping)this.registry.get(encodingStyleURI);
        mapping.setEncodingStyleURI(encodingStyleURI);
        this.registry.put(encodingStyleURI, mapping);
        return previous;
    }

    public void registerDefault(TypeMapping mapping) {
        this.defaultTM = mapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return this.registry.keySet().toArray(new String[this.registry.size()]);
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.registry.get(encodingStyleURI);
    }

    public TypeMapping createTypeMapping(boolean autoTypes) {
        return this.createTypeMapping(this.getDefaultTypeMapping(), autoTypes);
    }

    public TypeMapping createTypeMapping(String parentNamespace, boolean autoTypes) {
        return this.createTypeMapping(this.getTypeMapping(parentNamespace), autoTypes);
    }

    protected TypeMapping createTypeMapping(TypeMapping parent, boolean autoTypes) {
        CustomTypeMapping tm = new CustomTypeMapping(parent);
        if (autoTypes) {
            tm.setTypeCreator(this.getTypeCreator());
        }
        return tm;
    }

    public TypeCreator getTypeCreator() {
        if (this.typeCreator == null) {
            this.typeCreator = this.createTypeCreator();
        }
        return this.typeCreator;
    }

    public void setTypeCreator(TypeCreator typeCreator) {
        this.typeCreator = typeCreator;
    }

    protected TypeCreator createTypeCreator() {
        AbstractTypeCreator xmlCreator;
        block3: {
            xmlCreator = this.createRootTypeCreator();
            xmlCreator.setNextCreator(new DefaultTypeCreator());
            if (this.isJDK5andAbove()) {
                try {
                    String j5TC = "org.codehaus.xfire.aegis.type.java5.Java5TypeCreator";
                    Class clazz = ClassLoaderUtils.loadClass((String)j5TC, this.getClass());
                    AbstractTypeCreator j5Creator = (AbstractTypeCreator)clazz.newInstance();
                    j5Creator.setNextCreator(new DefaultTypeCreator());
                    xmlCreator.setNextCreator(j5Creator);
                }
                catch (Throwable t) {
                    logger.info((Object)"Couldn't find Java 5 module on classpath. Annotation mappings will not be supported.");
                    if (t instanceof ClassNotFoundException) break block3;
                    logger.debug((Object)"Error loading Java 5 module", t);
                }
            }
        }
        return xmlCreator;
    }

    boolean isJDK5andAbove() {
        String v = System.getProperty("java.class.version", "44.0");
        return "49.0".compareTo(v) <= 0;
    }

    protected AbstractTypeCreator createRootTypeCreator() {
        return new XMLTypeCreator();
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        TypeMapping tm = (TypeMapping)this.registry.get(encodingStyleURI);
        this.registry.remove(encodingStyleURI);
        return tm;
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        int n = 0;
        Iterator itr = this.registry.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().equals(mapping)) continue;
            itr.remove();
            ++n;
        }
        return n > 0;
    }

    public void clear() {
        this.registry.clear();
    }

    public TypeMapping createDefaultMappings() {
        TypeMapping tm = this.createTypeMapping(false);
        tm.register(Boolean.TYPE, XSD_BOOLEAN, new BooleanType());
        tm.register(Integer.TYPE, XSD_INT, new IntType());
        tm.register(Short.TYPE, XSD_SHORT, new ShortType());
        tm.register(Double.TYPE, XSD_DOUBLE, new DoubleType());
        tm.register(Float.TYPE, XSD_FLOAT, new FloatType());
        tm.register(Long.TYPE, XSD_LONG, new LongType());
        tm.register(String.class, XSD_STRING, new StringType());
        tm.register(Boolean.class, XSD_BOOLEAN, new BooleanType());
        tm.register(Integer.class, XSD_INT, new IntType());
        tm.register(Short.class, XSD_SHORT, new ShortType());
        tm.register(Double.class, XSD_DOUBLE, new DoubleType());
        tm.register(Float.class, XSD_FLOAT, new FloatType());
        tm.register(Long.class, XSD_LONG, new LongType());
        tm.register(java.util.Date.class, XSD_DATETIME, new DateTimeType());
        tm.register(Date.class, XSD_DATETIME, new SqlDateType());
        tm.register(Time.class, XSD_TIME, new TimeType());
        tm.register(Timestamp.class, XSD_DATETIME, new TimestampType());
        tm.register(Calendar.class, XSD_DATETIME, new CalendarType());
        tm.register([B.class, XSD_BASE64, new Base64Type());
        tm.register(BigDecimal.class, XSD_DECIMAL, new BigDecimalType());
        tm.register(URI.class, XSD_URI, new URIType());
        tm.register(Document.class, XSD_ANY, new DocumentType());
        tm.register(Source.class, XSD_ANY, new SourceType());
        tm.register(XMLStreamReader.class, XSD_ANY, new XMLStreamReaderType());
        tm.register(Element.class, XSD_ANY, new JDOMElementType());
        tm.register(Object.class, XSD_ANY, new ObjectType());
        this.register("http://www.w3.org/2001/XMLSchema", tm);
        this.registerDefault(tm);
        TypeMapping soapTM = this.createTypeMapping(tm, false);
        soapTM.register(Boolean.TYPE, ENCODED_BOOLEAN, new BooleanType());
        soapTM.register(Integer.TYPE, ENCODED_INT, new IntType());
        soapTM.register(Short.TYPE, ENCODED_SHORT, new ShortType());
        soapTM.register(Double.TYPE, ENCODED_DOUBLE, new DoubleType());
        soapTM.register(Float.TYPE, ENCODED_FLOAT, new FloatType());
        soapTM.register(Long.TYPE, ENCODED_LONG, new LongType());
        soapTM.register(String.class, ENCODED_STRING, new StringType());
        soapTM.register(Boolean.class, ENCODED_BOOLEAN, new BooleanType());
        soapTM.register(Integer.class, ENCODED_INT, new IntType());
        soapTM.register(Short.class, ENCODED_SHORT, new ShortType());
        soapTM.register(Double.class, ENCODED_DOUBLE, new DoubleType());
        soapTM.register(Float.class, ENCODED_FLOAT, new FloatType());
        soapTM.register(Long.class, ENCODED_LONG, new LongType());
        soapTM.register(java.util.Date.class, ENCODED_DATETIME, new DateTimeType());
        soapTM.register(Date.class, ENCODED_DATETIME, new SqlDateType());
        soapTM.register(Calendar.class, ENCODED_DATETIME, new CalendarType());
        soapTM.register([B.class, ENCODED_BASE64, new Base64Type());
        soapTM.register(BigDecimal.class, ENCODED_DECIMAL, new BigDecimalType());
        soapTM.register(Boolean.TYPE, XSD_BOOLEAN, new BooleanType());
        soapTM.register(Integer.TYPE, XSD_INT, new IntType());
        soapTM.register(Short.TYPE, XSD_SHORT, new ShortType());
        soapTM.register(Double.TYPE, XSD_DOUBLE, new DoubleType());
        soapTM.register(Float.TYPE, XSD_FLOAT, new FloatType());
        soapTM.register(Long.TYPE, XSD_LONG, new LongType());
        soapTM.register(String.class, XSD_STRING, new StringType());
        soapTM.register(Boolean.class, XSD_BOOLEAN, new BooleanType());
        soapTM.register(Integer.class, XSD_INT, new IntType());
        soapTM.register(Short.class, XSD_SHORT, new ShortType());
        soapTM.register(Double.class, XSD_DOUBLE, new DoubleType());
        soapTM.register(Float.class, XSD_FLOAT, new FloatType());
        soapTM.register(Long.class, XSD_LONG, new LongType());
        soapTM.register(java.util.Date.class, XSD_DATETIME, new DateTimeType());
        soapTM.register(Date.class, XSD_DATETIME, new SqlDateType());
        soapTM.register(Time.class, XSD_TIME, new TimeType());
        soapTM.register(Timestamp.class, XSD_DATETIME, new TimestampType());
        soapTM.register(Calendar.class, XSD_DATETIME, new CalendarType());
        soapTM.register([B.class, XSD_BASE64, new Base64Type());
        soapTM.register(BigDecimal.class, XSD_DECIMAL, new BigDecimalType());
        soapTM.register(URI.class, XSD_URI, new URIType());
        soapTM.register(Document.class, XSD_ANY, new DocumentType());
        soapTM.register(Source.class, XSD_ANY, new SourceType());
        soapTM.register(XMLStreamReader.class, XSD_ANY, new XMLStreamReaderType());
        soapTM.register(Element.class, XSD_ANY, new JDOMElementType());
        soapTM.register(Object.class, XSD_ANY, new ObjectType());
        this.register(ENCODED_NS, soapTM);
        return tm;
    }
}

