/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.Base64;

public class Base64Type
extends Type {
    public Base64Type() {
        this.setNillable(true);
    }

    public Object readObject(MessageReader mreader, MessageContext context) throws XFireFault {
        XMLStreamReader reader = mreader.getXMLStreamReader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int event = reader.next();
            if (!reader.isCharacters() && !reader.isWhiteSpace()) {
                return null;
            }
            int length = 1024;
            char[] myBuffer = new char[length];
            int sourceStart = 0;
            while (true) {
                int nCopied = reader.getTextCharacters(sourceStart, myBuffer, 0, length);
                Base64.decode((char[])myBuffer, (int)0, (int)nCopied, (OutputStream)bos);
                if (nCopied < length) break;
                sourceStart += length;
            }
            while (reader.getEventType() != 2) {
                reader.next();
            }
            reader.next();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new XFireFault("Could not parse base64Binary data.", (Throwable)e, XFireFault.SENDER);
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse base64Binary data.", (Throwable)e, XFireFault.SENDER);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        byte[] data = (byte[])object;
        writer.writeValue(Base64.encode((byte[])data, (int)0, (int)data.length));
    }
}

