/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class ArrayType
extends Type {
    private QName componentName;
    private static final Log logger = LogFactory.getLog((Class)ArrayType.class);
    private long minOccurs = 0L;
    private long maxOccurs = Long.MAX_VALUE;
    private boolean flat;

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Collection values = this.readCollection(reader, context);
            return this.makeArray(this.getComponentType().getTypeClass(), values);
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    protected Collection createCollection() {
        return new ArrayList();
    }

    protected Collection readCollection(MessageReader reader, MessageContext context) throws XFireFault {
        Type compType = this.getComponentType();
        Collection values = this.createCollection();
        while (reader.hasMoreElementReaders()) {
            int size;
            MessageReader creader = reader.getNextElementReader();
            if (creader.isXsiNil()) {
                values.add(null);
                creader.readToEnd();
            } else {
                values.add(compType.readObject(creader, context));
            }
            if ((long)(size = values.size()) <= this.maxOccurs) continue;
            throw new XFireFault("The number of elements in " + this.getSchemaType() + " exceeds the maximum of " + this.maxOccurs, XFireFault.SENDER);
        }
        if ((long)values.size() < this.minOccurs) {
            throw new XFireFault("The number of elements in " + this.getSchemaType() + " does not meet the minimum of " + this.minOccurs, XFireFault.SENDER);
        }
        return values;
    }

    protected Object makeArray(Class arrayType, Collection values) {
        if (Integer.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Integer.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Long.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Long.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Short.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Short.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Double.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Double.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Float.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Float.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Byte.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Byte.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Boolean.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Boolean.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        return values.toArray((Object[])Array.newInstance(this.getComponentType().getTypeClass(), values.size()));
    }

    public void writeObject(Object values, MessageWriter writer, MessageContext context) throws XFireFault {
        block11: {
            Class arrayType;
            String name;
            String ns;
            Type type;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        if (values == null) {
                                            return;
                                        }
                                        type = this.getComponentType();
                                        ns = null;
                                        ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                                        name = type.getSchemaType().getLocalPart();
                                        if (type == null) {
                                            throw new XFireRuntimeException("Couldn't find type for " + type.getTypeClass() + ".");
                                        }
                                        if (!Object.class.isAssignableFrom(arrayType = type.getTypeClass())) break block10;
                                        Object[] objects = (Object[])values;
                                        int n = objects.length;
                                        for (int i = 0; i < n; ++i) {
                                            this.writeValue(objects[i], writer, context, type, name, ns);
                                        }
                                        break block11;
                                    }
                                    if (!Integer.TYPE.equals(arrayType)) break block12;
                                    int[] objects = (int[])values;
                                    int n = objects.length;
                                    for (int i = 0; i < n; ++i) {
                                        this.writeValue(new Integer(objects[i]), writer, context, type, name, ns);
                                    }
                                    break block11;
                                }
                                if (!Long.TYPE.equals(arrayType)) break block13;
                                long[] objects = (long[])values;
                                int n = objects.length;
                                for (int i = 0; i < n; ++i) {
                                    this.writeValue(new Long(objects[i]), writer, context, type, name, ns);
                                }
                                break block11;
                            }
                            if (!Short.TYPE.equals(arrayType)) break block14;
                            short[] objects = (short[])values;
                            int n = objects.length;
                            for (int i = 0; i < n; ++i) {
                                this.writeValue(new Short(objects[i]), writer, context, type, name, ns);
                            }
                            break block11;
                        }
                        if (!Double.TYPE.equals(arrayType)) break block15;
                        double[] objects = (double[])values;
                        int n = objects.length;
                        for (int i = 0; i < n; ++i) {
                            this.writeValue(new Double(objects[i]), writer, context, type, name, ns);
                        }
                        break block11;
                    }
                    if (!Float.TYPE.equals(arrayType)) break block16;
                    float[] objects = (float[])values;
                    int n = objects.length;
                    for (int i = 0; i < n; ++i) {
                        this.writeValue(new Float(objects[i]), writer, context, type, name, ns);
                    }
                    break block11;
                }
                if (!Byte.TYPE.equals(arrayType)) break block17;
                byte[] objects = (byte[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Byte(objects[i]), writer, context, type, name, ns);
                }
                break block11;
            }
            if (!Boolean.TYPE.equals(arrayType)) break block11;
            boolean[] objects = (boolean[])values;
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                this.writeValue(new Boolean(objects[i]), writer, context, type, name, ns);
            }
        }
    }

    protected void writeValue(Object value, MessageWriter writer, MessageContext context, Type type, String name, String ns) throws XFireFault {
        MessageWriter cwriter = writer.getElementWriter(name, ns);
        if (value == null && type.isNillable()) {
            cwriter.writeXsiNil();
        } else {
            type.writeObject(value, cwriter, context);
        }
        cwriter.close();
    }

    public void writeSchema(Element root) {
        try {
            Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
            root.addContent((Content)complex);
            Element seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)seq);
            Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
            seq.addContent((Content)element);
            Type componentType = this.getComponentType();
            String prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)componentType.getSchemaType().getNamespaceURI());
            String typeName = prefix + ":" + componentType.getSchemaType().getLocalPart();
            element.setAttribute(new Attribute("name", componentType.getSchemaType().getLocalPart()));
            element.setAttribute(new Attribute("type", typeName));
            if (componentType.isNillable()) {
                element.setAttribute(new Attribute("nillable", "true"));
            }
            element.setAttribute(new Attribute("minOccurs", new Long(this.getMinOccurs()).toString()));
            if (this.maxOccurs == Long.MAX_VALUE) {
                element.setAttribute(new Attribute("maxOccurs", "unbounded"));
            } else {
                element.setAttribute(new Attribute("maxOccurs", new Long(this.getMaxOccurs()).toString()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    public Type getComponentType() {
        Type type;
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            type = this.getTypeMapping().getType(compType);
        } else {
            type = this.getTypeMapping().getType(this.componentName);
            if (type == null) {
                logger.debug((Object)("Couldn't find array component type " + this.componentName + ". Creating one instead."));
            }
        }
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(compType);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(long maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(long minOccurs) {
        this.minOccurs = minOccurs;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.setWriteOuter(!flat);
        this.flat = flat;
    }
}

