/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.jdom;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.aegis.AbstractMessageReader;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.stax.AttributeReader;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class JDOMReader
extends AbstractMessageReader
implements MessageReader {
    private Element element;
    private int currentChild = 0;
    private int currentAttribute = 0;
    private List elements;
    private QName qname;

    public JDOMReader(Element element) {
        this.element = element;
        this.elements = element.getChildren();
    }

    public String getValue() {
        return this.element.getValue();
    }

    public String getValue(String ns, String attr) {
        return this.element.getAttributeValue(attr, ns);
    }

    public boolean hasMoreElementReaders() {
        return this.currentChild < this.elements.size();
    }

    public MessageReader getNextElementReader() {
        ++this.currentChild;
        return new JDOMReader((Element)this.elements.get(this.currentChild - 1));
    }

    public QName getName() {
        if (this.qname == null) {
            this.qname = new QName(this.element.getNamespaceURI(), this.element.getName(), this.element.getNamespacePrefix());
        }
        return this.qname;
    }

    public String getLocalName() {
        return this.element.getName();
    }

    public String getNamespace() {
        return this.element.getNamespaceURI();
    }

    public XMLStreamReader getXMLStreamReader() {
        return new JDOMStreamReader(this.element);
    }

    public boolean hasMoreAttributeReaders() {
        return this.currentAttribute < this.element.getAttributes().size();
    }

    public MessageReader getAttributeReader(QName attName) {
        String value = this.element.getAttributeValue(attName.getLocalPart(), Namespace.getNamespace((String)attName.getNamespaceURI()));
        return new AttributeReader(attName, value);
    }

    public MessageReader getNextAttributeReader() {
        ++this.currentAttribute;
        Attribute att = (Attribute)this.element.getAttributes().get(this.currentAttribute);
        return new AttributeReader(new QName(att.getNamespaceURI(), att.getName()), att.getValue());
    }

    public String getNamespaceForPrefix(String prefix) {
        Namespace namespace = this.element.getNamespace(prefix);
        return null == namespace ? null : namespace.getURI();
    }
}

