/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;

public class DefaultEndpoint
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)DefaultEndpoint.class);
    public static final String SERVICE_HANDLERS_REGISTERED = "service.handlers.registered";

    public void onReceive(MessageContext context, InMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message to " + msg.getUri()));
        }
        if (context.getExchange() == null) {
            MessageExchange exchange = new MessageExchange(context);
            exchange.setInMessage(msg);
            context.setCurrentMessage(msg);
        }
        HandlerPipeline pipeline = new HandlerPipeline(context.getXFire().getInPhases());
        pipeline.addHandlers(context.getXFire().getInHandlers());
        pipeline.addHandlers(msg.getChannel().getTransport().getInHandlers());
        if (context.getService() != null) {
            pipeline.addHandlers(context.getService().getInHandlers());
            context.setProperty(SERVICE_HANDLERS_REGISTERED, Boolean.TRUE);
        }
        context.setInPipeline(pipeline);
        try {
            pipeline.invoke(context);
        }
        catch (Exception e) {
            this.handleException(context, pipeline, e);
        }
    }

    protected void handleException(MessageContext context, HandlerPipeline pipeline, Exception e) {
        if (e instanceof RuntimeException) {
            log.error((Object)"Fault occurred!", (Throwable)e);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Fault occurred!", (Throwable)e);
        }
        XFireFault fault = XFireFault.createFault(e);
        pipeline.handleFault(fault, context);
        Service service = context.getService();
        if (service == null || service.getFaultSerializer() == null || !context.getExchange().hasFaultMessage()) {
            this.sendToDeadLetter(fault, context);
        } else {
            this.sendFault(fault, context);
        }
    }

    protected void sendToDeadLetter(XFireFault fault, MessageContext context) {
        log.error((Object)"Could not find service.", (Throwable)fault);
    }

    protected void sendFault(XFireFault fault, MessageContext context) {
        OutMessage outMsg = (OutMessage)context.getExchange().getFaultMessage();
        outMsg.setSerializer(context.getService().getFaultSerializer());
        outMsg.setBody(fault);
        context.setCurrentMessage(outMsg);
        HandlerPipeline faultPipe = new HandlerPipeline(context.getXFire().getFaultPhases());
        faultPipe.addHandlers(context.getXFire().getFaultHandlers());
        Channel faultChannel = context.getExchange().getFaultMessage().getChannel();
        if (faultChannel != null) {
            faultPipe.addHandlers(faultChannel.getTransport().getFaultHandlers());
        }
        if (context.getService() != null) {
            faultPipe.addHandlers(context.getService().getFaultHandlers());
        }
        try {
            faultPipe.invoke(context);
        }
        catch (Exception e1) {
            XFireFault fault2 = XFireFault.createFault(e1);
            faultPipe.handleFault(fault2, context);
            log.error((Object)"Could not send fault.", (Throwable)e1);
        }
    }

    public void finishReadingMessage(InMessage message, MessageContext context) throws XFireFault {
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            int event = reader.getEventType();
            while (event != 8 && reader.hasNext()) {
                event = reader.next();
            }
        }
        catch (XMLStreamException e) {
            log.warn((Object)"Couldn't parse to end of message.", (Throwable)e);
        }
    }
}

