/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.HttpChannel;
import org.codehaus.xfire.transport.http.OutMessageRequestEntity;
import org.codehaus.xfire.util.STAXUtils;

public class CommonsHttpMessageSender
extends AbstractMessageSender {
    private static final ThreadLocal httpState = new ThreadLocal();
    private PostMethod postMethod;
    private HttpClient client;
    private static final Log log = LogFactory.getLog((Class)CommonsHttpMessageSender.class);
    public static final String HTTP_CLIENT_PARAMS = "httpClient.params";
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)";

    public CommonsHttpMessageSender(OutMessage message, MessageContext context) {
        super(message, context);
    }

    public void open() throws IOException, XFireException {
        Attachments atts;
        this.client = new HttpClient();
        MessageContext context = this.getMessageContext();
        HttpClientParams params = (HttpClientParams)context.getContextualProperty(HTTP_CLIENT_PARAMS);
        if (params == null) {
            params = this.client.getParams();
            this.client.getParams().setParameter("http.useragent", (Object)USER_AGENT);
            this.client.getParams().setBooleanParameter("http.protocol.expect-continue", true);
            this.client.getParams().setVersion(HttpVersion.HTTP_1_1);
        } else {
            this.client.setParams(params);
        }
        this.postMethod = new PostMethod(this.getUri());
        String username = (String)context.getContextualProperty("username");
        if (username != null) {
            String password = (String)context.getContextualProperty("password");
            this.client.getParams().setAuthenticationPreemptive(true);
            this.getHttpState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        if (this.getSoapAction() != null) {
            this.postMethod.setRequestHeader("SOAPAction", this.getQuotedSoapAction());
        }
        if ((atts = this.getMessage().getAttachments()) != null && atts.size() > 0) {
            HttpChannel.writeAttachmentBody(context, this.getMessage());
            this.postMethod.setRequestHeader("Content-Type", atts.getContentType());
        } else {
            this.postMethod.setRequestHeader("Content-Type", HttpChannel.getSoapMimeType(this.getMessage()));
        }
    }

    public void send() throws HttpException, IOException, XFireException {
        boolean chunkingOn = Boolean.valueOf((String)this.getMessageContext().getContextualProperty("urn:xfire:transport:http:chunking-enabled"));
        Object requestEntity = !chunkingOn ? this.getByteArrayRequestEntity() : new OutMessageRequestEntity(this.getMessage(), this.getMessageContext());
        this.getMethod().setRequestEntity(requestEntity);
        this.client.executeMethod(null, (HttpMethod)this.postMethod, this.getHttpState());
    }

    public boolean hasResponse() {
        String ct = this.postMethod.getResponseHeader("Content-Type").getValue();
        return ct != null && ct.length() > 0;
    }

    private HttpState getHttpState() {
        HttpState state = (HttpState)httpState.get();
        if (null == state) {
            state = new HttpState();
            httpState.set(state);
        }
        return state;
    }

    private RequestEntity getByteArrayRequestEntity() throws IOException, XFireException {
        OutMessage message = this.getMessage();
        MessageContext context = this.getMessageContext();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(bos, message.getEncoding(), context);
        Attachments atts = message.getAttachments();
        if (atts != null && atts.size() > 0) {
            atts.write(bos);
        } else {
            HttpChannel.writeWithoutAttachments(context, message, bos);
        }
        return new ByteArrayRequestEntity(bos.toByteArray());
    }

    public InMessage getInMessage() throws IOException {
        String ct = this.postMethod.getResponseHeader("Content-Type").getValue();
        InputStream in = this.postMethod.getResponseBodyAsStream();
        if (ct.toLowerCase().indexOf("multipart/related") != -1) {
            try {
                JavaMailAttachments atts = new JavaMailAttachments(in, ct);
                InputStream msgIs = atts.getSoapMessage().getDataHandler().getInputStream();
                InMessage msg = new InMessage(STAXUtils.createXMLStreamReader(msgIs, this.getEncoding(), this.getMessageContext()), this.getUri());
                msg.setAttachments(atts);
                return msg;
            }
            catch (MessagingException e) {
                log.error((Object)e);
                throw new IOException(e.getMessage());
            }
        }
        return new InMessage(STAXUtils.createXMLStreamReader(in, this.getEncoding(), this.getMessageContext()), this.getUri());
    }

    public PostMethod getMethod() {
        return this.postMethod;
    }

    public void close() throws XFireException {
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
        }
    }
}

