/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.util.FastStack;

public abstract class DOMStreamReader
implements XMLStreamReader {
    public Map properties = new HashMap();
    private FastStack frames = new FastStack();
    private ElementFrame frame;
    private int currentEvent = 7;

    public DOMStreamReader(ElementFrame frame) {
        this.frame = frame;
        this.frames.push(this.frame);
        this.newFrame(frame);
    }

    protected ElementFrame getCurrentFrame() {
        return this.frame;
    }

    public Object getProperty(String key) throws IllegalArgumentException {
        return this.properties.get(key);
    }

    public int next() throws XMLStreamException {
        if (this.frame.ended) {
            this.frames.pop();
            if (!this.frames.isEmpty()) {
                this.frame = (ElementFrame)this.frames.peek();
            } else {
                this.currentEvent = 8;
                return this.currentEvent;
            }
        }
        if (!this.frame.started) {
            this.frame.started = true;
            this.currentEvent = 1;
        } else if (this.frame.currentAttribute < this.getAttributeCount() - 1) {
            ++this.frame.currentAttribute;
            this.currentEvent = 10;
        } else if (this.frame.currentNamespace < this.getNamespaceCount() - 1) {
            ++this.frame.currentNamespace;
            this.currentEvent = 13;
        } else if (this.frame.currentChild < this.getChildCount() - 1) {
            ++this.frame.currentChild;
            this.currentEvent = this.moveToChild(this.frame.currentChild);
            if (this.currentEvent == 1) {
                ElementFrame newFrame = this.getChildFrame(this.frame.currentChild);
                newFrame.started = true;
                this.frame = newFrame;
                this.frames.push(this.frame);
                this.currentEvent = 1;
                this.newFrame(newFrame);
            }
        } else {
            this.frame.ended = true;
            this.currentEvent = 2;
            this.endElement();
        }
        return this.currentEvent;
    }

    protected void newFrame(ElementFrame newFrame) {
    }

    protected void endElement() {
    }

    protected abstract int moveToChild(int var1);

    protected abstract ElementFrame getChildFrame(int var1);

    protected abstract int getChildCount();

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public abstract String getElementText() throws XMLStreamException;

    public int nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            if (1 != this.next()) continue;
            return 1;
        }
        return this.currentEvent;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.frames.size() != 0 || !this.frame.ended;
    }

    public void close() throws XMLStreamException {
    }

    public abstract String getNamespaceURI(String var1);

    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    public boolean isWhiteSpace() {
        return this.currentEvent == 6;
    }

    public int getEventType() {
        return this.currentEvent;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    public Location getLocation() {
        return null;
    }

    public boolean hasName() {
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public static class ElementFrame {
        Object element;
        boolean started = false;
        boolean ended = false;
        int currentChild = -1;
        int currentAttribute = -1;
        int currentNamespace = -1;
        int currentElement = -1;
        List uris;
        List prefixes;
        List attributes;
        List allAttributes;
        final ElementFrame parent;

        public ElementFrame(Object element, ElementFrame parent) {
            this.element = element;
            this.parent = parent;
        }
    }
}

