/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMStreamWriterHelper {
    private DOMStreamWriterHelper() {
    }

    public static void write(XMLStreamWriter writer, Document document) throws Exception {
        writer.writeStartDocument();
        Element root = document.getDocumentElement();
        DOMStreamWriterHelper.writeElement(writer, root);
        writer.writeEndDocument();
    }

    private static void writeElement(XMLStreamWriter writer, Element element) throws Exception {
        String name = element.getLocalName();
        String prefix = element.getPrefix();
        String uri = element.getNamespaceURI();
        if (uri != null) {
            if (prefix != null) {
                writer.writeStartElement(prefix, name, uri);
            } else {
                writer.writeStartElement(uri, name);
            }
        } else {
            writer.writeStartElement(name);
        }
        DOMStreamWriterHelper.writeAttributes(writer, element);
        NodeList nodeList = element.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                DOMStreamWriterHelper.writeElement(writer, (Element)node);
                continue;
            }
            if (!(node instanceof Text)) continue;
            writer.writeCharacters(((Text)node).getData());
        }
        writer.writeEndElement();
    }

    private static void writeAttributes(XMLStreamWriter writer, Element element) throws Exception {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node node = attrs.item(i);
            String localName = node.getLocalName();
            if (localName == null) {
                localName = node.getNodeName();
            }
            String nodeUri = node.getNamespaceURI();
            String nodePrefix = node.getPrefix();
            String nodeValue = node.getNodeValue();
            writer.writeAttribute(nodePrefix, nodeUri, localName, nodeValue);
        }
    }
}

