/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.Configuration;
import org.codehaus.xfire.aegis.type.CustomTypeMapping;
import org.codehaus.xfire.aegis.type.DefaultTypeCreator;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.aegis.type.XMLTypeCreator;
import org.codehaus.xfire.aegis.type.basic.Base64Type;
import org.codehaus.xfire.aegis.type.basic.BigDecimalType;
import org.codehaus.xfire.aegis.type.basic.BigIntegerType;
import org.codehaus.xfire.aegis.type.basic.BooleanType;
import org.codehaus.xfire.aegis.type.basic.CalendarType;
import org.codehaus.xfire.aegis.type.basic.DateTimeType;
import org.codehaus.xfire.aegis.type.basic.DoubleType;
import org.codehaus.xfire.aegis.type.basic.FloatType;
import org.codehaus.xfire.aegis.type.basic.IntType;
import org.codehaus.xfire.aegis.type.basic.LongType;
import org.codehaus.xfire.aegis.type.basic.ObjectType;
import org.codehaus.xfire.aegis.type.basic.ShortType;
import org.codehaus.xfire.aegis.type.basic.SqlDateType;
import org.codehaus.xfire.aegis.type.basic.StringType;
import org.codehaus.xfire.aegis.type.basic.TimeType;
import org.codehaus.xfire.aegis.type.basic.TimestampType;
import org.codehaus.xfire.aegis.type.basic.URIType;
import org.codehaus.xfire.aegis.type.mtom.DataHandlerType;
import org.codehaus.xfire.aegis.type.mtom.DataSourceType;
import org.codehaus.xfire.aegis.type.xml.DocumentType;
import org.codehaus.xfire.aegis.type.xml.JDOMElementType;
import org.codehaus.xfire.aegis.type.xml.SourceType;
import org.codehaus.xfire.aegis.type.xml.XMLStreamReaderType;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.jdom.Element;
import org.w3c.dom.Document;

public class DefaultTypeMappingRegistry
implements TypeMappingRegistry {
    private static final Log logger = LogFactory.getLog((Class)DefaultTypeMappingRegistry.class);
    protected static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    protected static final QName XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd");
    protected static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd");
    protected static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd");
    protected static final QName XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd");
    protected static final QName XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd");
    protected static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd");
    protected static final QName XSD_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    protected static final QName XSD_TIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    protected static final QName XSD_BASE64 = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xsd");
    protected static final QName XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal", "xsd");
    protected static final QName XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer", "xsd");
    protected static final QName XSD_URI = new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xsd");
    protected static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    protected static final String ENCODED_NS = Soap11.getInstance().getSoapEncodingStyle();
    protected static final QName ENCODED_STRING = new QName(ENCODED_NS, "string");
    protected static final QName ENCODED_LONG = new QName(ENCODED_NS, "long");
    protected static final QName ENCODED_FLOAT = new QName(ENCODED_NS, "float");
    protected static final QName ENCODED_DOUBLE = new QName(ENCODED_NS, "double");
    protected static final QName ENCODED_INT = new QName(ENCODED_NS, "int");
    protected static final QName ENCODED_SHORT = new QName(ENCODED_NS, "short");
    protected static final QName ENCODED_BOOLEAN = new QName(ENCODED_NS, "boolean");
    protected static final QName ENCODED_DATETIME = new QName(ENCODED_NS, "dateTime");
    protected static final QName ENCODED_BASE64 = new QName(ENCODED_NS, "base64Binary");
    protected static final QName ENCODED_DECIMAL = new QName(ENCODED_NS, "decimal");
    protected static final QName ENCODED_INTEGER = new QName(ENCODED_NS, "integer");
    private Hashtable registry = new Hashtable();
    private TypeMapping defaultTM;
    private TypeCreator typeCreator;
    private Configuration typeConfiguration;

    public DefaultTypeMappingRegistry() {
        this(false);
    }

    public DefaultTypeMappingRegistry(boolean createDefault) {
        this(null, createDefault);
    }

    public DefaultTypeMappingRegistry(TypeCreator typeCreator, boolean createDefault) {
        this.typeCreator = typeCreator;
        this.typeConfiguration = new Configuration();
        if (createDefault) {
            this.createDefaultMappings();
        }
    }

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        TypeMapping previous = (TypeMapping)this.registry.get(encodingStyleURI);
        mapping.setEncodingStyleURI(encodingStyleURI);
        this.registry.put(encodingStyleURI, mapping);
        return previous;
    }

    public void registerDefault(TypeMapping mapping) {
        this.defaultTM = mapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return this.registry.keySet().toArray(new String[this.registry.size()]);
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.registry.get(encodingStyleURI);
    }

    public TypeMapping createTypeMapping(boolean autoTypes) {
        return this.createTypeMapping(this.getDefaultTypeMapping(), autoTypes);
    }

    public TypeMapping createTypeMapping(String parentNamespace, boolean autoTypes) {
        return this.createTypeMapping(this.getTypeMapping(parentNamespace), autoTypes);
    }

    protected TypeMapping createTypeMapping(TypeMapping parent, boolean autoTypes) {
        CustomTypeMapping tm = new CustomTypeMapping(parent);
        if (autoTypes) {
            tm.setTypeCreator(this.getTypeCreator());
        }
        return tm;
    }

    public TypeCreator getTypeCreator() {
        if (this.typeCreator == null) {
            this.typeCreator = this.createTypeCreator();
        }
        return this.typeCreator;
    }

    public void setTypeCreator(TypeCreator typeCreator) {
        this.typeCreator = typeCreator;
    }

    protected TypeCreator createTypeCreator() {
        AbstractTypeCreator xmlCreator;
        block3: {
            xmlCreator = this.createRootTypeCreator();
            xmlCreator.setNextCreator(this.createDefaultTypeCreator());
            if (this.isJDK5andAbove()) {
                try {
                    String j5TC = "org.codehaus.xfire.aegis.type.java5.Java5TypeCreator";
                    Class clazz = ClassLoaderUtils.loadClass(j5TC, this.getClass());
                    AbstractTypeCreator j5Creator = (AbstractTypeCreator)clazz.newInstance();
                    j5Creator.setNextCreator(this.createDefaultTypeCreator());
                    j5Creator.setConfiguration(this.getConfiguration());
                    xmlCreator.setNextCreator(j5Creator);
                }
                catch (Throwable t) {
                    logger.info((Object)"Couldn't find Java 5 module on classpath. Annotation mappings will not be supported.");
                    if (t instanceof ClassNotFoundException) break block3;
                    logger.debug((Object)"Error loading Java 5 module", t);
                }
            }
        }
        return xmlCreator;
    }

    boolean isJDK5andAbove() {
        String v = System.getProperty("java.class.version", "44.0");
        return "49.0".compareTo(v) <= 0;
    }

    protected AbstractTypeCreator createRootTypeCreator() {
        XMLTypeCreator creator = new XMLTypeCreator();
        creator.setConfiguration(this.getConfiguration());
        return creator;
    }

    protected AbstractTypeCreator createDefaultTypeCreator() {
        DefaultTypeCreator creator = new DefaultTypeCreator();
        creator.setConfiguration(this.getConfiguration());
        return creator;
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        TypeMapping tm = (TypeMapping)this.registry.get(encodingStyleURI);
        this.registry.remove(encodingStyleURI);
        return tm;
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        int n = 0;
        Iterator itr = this.registry.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().equals(mapping)) continue;
            itr.remove();
            ++n;
        }
        return n > 0;
    }

    public void clear() {
        this.registry.clear();
    }

    public TypeMapping createDefaultMappings() {
        TypeMapping tm = this.createTypeMapping(false);
        this.register(tm, Boolean.TYPE, XSD_BOOLEAN, new BooleanType());
        this.register(tm, Integer.TYPE, XSD_INT, new IntType());
        this.register(tm, Short.TYPE, XSD_SHORT, new ShortType());
        this.register(tm, Double.TYPE, XSD_DOUBLE, new DoubleType());
        this.register(tm, Float.TYPE, XSD_FLOAT, new FloatType());
        this.register(tm, Long.TYPE, XSD_LONG, new LongType());
        this.register(tm, String.class, XSD_STRING, new StringType());
        this.register(tm, Boolean.class, XSD_BOOLEAN, new BooleanType());
        this.register(tm, Integer.class, XSD_INT, new IntType());
        this.register(tm, Short.class, XSD_SHORT, new ShortType());
        this.register(tm, Double.class, XSD_DOUBLE, new DoubleType());
        this.register(tm, Float.class, XSD_FLOAT, new FloatType());
        this.register(tm, Long.class, XSD_LONG, new LongType());
        this.register(tm, java.util.Date.class, XSD_DATETIME, new DateTimeType());
        this.register(tm, Date.class, XSD_DATETIME, new SqlDateType());
        this.register(tm, Time.class, XSD_TIME, new TimeType());
        this.register(tm, Timestamp.class, XSD_DATETIME, new TimestampType());
        this.register(tm, Calendar.class, XSD_DATETIME, new CalendarType());
        this.register(tm, [B.class, XSD_BASE64, new Base64Type());
        this.register(tm, BigDecimal.class, XSD_DECIMAL, new BigDecimalType());
        this.register(tm, BigInteger.class, XSD_INTEGER, new BigIntegerType());
        this.register(tm, URI.class, XSD_URI, new URIType());
        this.register(tm, Document.class, XSD_ANY, new DocumentType());
        this.register(tm, Source.class, XSD_ANY, new SourceType());
        this.register(tm, XMLStreamReader.class, XSD_ANY, new XMLStreamReaderType());
        this.register(tm, Element.class, XSD_ANY, new JDOMElementType());
        this.register(tm, Object.class, XSD_ANY, new ObjectType());
        this.register(tm, DataSource.class, XSD_BASE64, new DataSourceType());
        this.register(tm, DataHandler.class, XSD_BASE64, new DataHandlerType());
        this.register("http://www.w3.org/2001/XMLSchema", tm);
        this.registerDefault(tm);
        TypeMapping soapTM = this.createTypeMapping(tm, false);
        this.register(soapTM, Boolean.TYPE, ENCODED_BOOLEAN, new BooleanType());
        this.register(soapTM, Integer.TYPE, ENCODED_INT, new IntType());
        this.register(soapTM, Short.TYPE, ENCODED_SHORT, new ShortType());
        this.register(soapTM, Double.TYPE, ENCODED_DOUBLE, new DoubleType());
        this.register(soapTM, Float.TYPE, ENCODED_FLOAT, new FloatType());
        this.register(soapTM, Long.TYPE, ENCODED_LONG, new LongType());
        this.register(soapTM, String.class, ENCODED_STRING, new StringType());
        this.register(soapTM, Boolean.class, ENCODED_BOOLEAN, new BooleanType());
        this.register(soapTM, Integer.class, ENCODED_INT, new IntType());
        this.register(soapTM, Short.class, ENCODED_SHORT, new ShortType());
        this.register(soapTM, Double.class, ENCODED_DOUBLE, new DoubleType());
        this.register(soapTM, Float.class, ENCODED_FLOAT, new FloatType());
        this.register(soapTM, Long.class, ENCODED_LONG, new LongType());
        this.register(soapTM, java.util.Date.class, ENCODED_DATETIME, new DateTimeType());
        this.register(soapTM, Date.class, ENCODED_DATETIME, new SqlDateType());
        this.register(soapTM, Calendar.class, ENCODED_DATETIME, new CalendarType());
        this.register(soapTM, [B.class, ENCODED_BASE64, new Base64Type());
        this.register(soapTM, BigDecimal.class, ENCODED_DECIMAL, new BigDecimalType());
        this.register(soapTM, BigInteger.class, ENCODED_INTEGER, new BigIntegerType());
        this.register(soapTM, Boolean.TYPE, XSD_BOOLEAN, new BooleanType());
        this.register(soapTM, Integer.TYPE, XSD_INT, new IntType());
        this.register(soapTM, Short.TYPE, XSD_SHORT, new ShortType());
        this.register(soapTM, Double.TYPE, XSD_DOUBLE, new DoubleType());
        this.register(soapTM, Float.TYPE, XSD_FLOAT, new FloatType());
        this.register(soapTM, Long.TYPE, XSD_LONG, new LongType());
        this.register(soapTM, String.class, XSD_STRING, new StringType());
        this.register(soapTM, Boolean.class, XSD_BOOLEAN, new BooleanType());
        this.register(soapTM, Integer.class, XSD_INT, new IntType());
        this.register(soapTM, Short.class, XSD_SHORT, new ShortType());
        this.register(soapTM, Double.class, XSD_DOUBLE, new DoubleType());
        this.register(soapTM, Float.class, XSD_FLOAT, new FloatType());
        this.register(soapTM, Long.class, XSD_LONG, new LongType());
        this.register(soapTM, java.util.Date.class, XSD_DATETIME, new DateTimeType());
        this.register(soapTM, Date.class, XSD_DATETIME, new SqlDateType());
        this.register(soapTM, Time.class, XSD_TIME, new TimeType());
        this.register(soapTM, Timestamp.class, XSD_DATETIME, new TimestampType());
        this.register(soapTM, Calendar.class, XSD_DATETIME, new CalendarType());
        this.register(soapTM, [B.class, XSD_BASE64, new Base64Type());
        this.register(soapTM, BigDecimal.class, XSD_DECIMAL, new BigDecimalType());
        this.register(soapTM, URI.class, XSD_URI, new URIType());
        this.register(soapTM, Document.class, XSD_ANY, new DocumentType());
        this.register(soapTM, Source.class, XSD_ANY, new SourceType());
        this.register(soapTM, XMLStreamReader.class, XSD_ANY, new XMLStreamReaderType());
        this.register(soapTM, Element.class, XSD_ANY, new JDOMElementType());
        this.register(soapTM, Object.class, XSD_ANY, new ObjectType());
        this.register(soapTM, DataSource.class, XSD_BASE64, new DataSourceType());
        this.register(soapTM, DataHandler.class, XSD_BASE64, new DataHandlerType());
        this.register(soapTM, BigInteger.class, XSD_INTEGER, new BigIntegerType());
        this.register(ENCODED_NS, soapTM);
        return tm;
    }

    protected void register(TypeMapping tm, Class class1, QName name, Type type) {
        if (!this.getConfiguration().isDefaultNillable()) {
            type.setNillable(false);
        }
        tm.register(class1, name, type);
    }

    public Configuration getConfiguration() {
        return this.typeConfiguration;
    }

    public void setConfiguration(Configuration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }
}

