/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.mtom.ByteArrayType;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.Base64;

public class Base64Type
extends Type {
    private static ByteArrayType optimizedType = new ByteArrayType();

    public Object readObject(MessageReader mreader, MessageContext context) throws XFireFault {
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        if (mtomEnabled) {
            return optimizedType.readObject(mreader, context);
        }
        XMLStreamReader reader = mreader.getXMLStreamReader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int event = reader.next();
            if (!reader.isCharacters() && !reader.isWhiteSpace()) {
                return null;
            }
            int length = 1024;
            char[] myBuffer = new char[length];
            int sourceStart = 0;
            while (true) {
                int nCopied = reader.getTextCharacters(sourceStart, myBuffer, 0, length);
                Base64.decode(myBuffer, 0, nCopied, bos);
                if (nCopied < length) break;
                sourceStart += length;
            }
            while (reader.getEventType() != 2) {
                reader.next();
            }
            reader.next();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new XFireFault("Could not parse base64Binary data.", e, XFireFault.SENDER);
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse base64Binary data.", e, XFireFault.SENDER);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        if (mtomEnabled) {
            optimizedType.writeObject(object, writer, context);
            return;
        }
        byte[] data = (byte[])object;
        writer.writeValue(Base64.encode(data, 0, data.length));
    }
}

