/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.attachments;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.AttachmentDataSource;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.util.CachedOutputStream;

public class StreamedAttachments
implements Attachments {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    private boolean soapMessageRead = false;
    private PushbackInputStream stream;
    private String boundary;
    private int threshold = 102400;
    private File tempDirectory;
    private Map parts = new HashMap();
    private Attachment soapMessage;
    private String contentType;
    private List cache = new ArrayList();
    private MessageContext context;

    public StreamedAttachments(InputStream is, String contentType) throws IOException {
        this(null, is, contentType);
    }

    public StreamedAttachments(MessageContext context, InputStream is, String contentType) throws IOException {
        int len;
        int end;
        int i = contentType.indexOf("boundary=\"");
        if (i == -1) {
            i = contentType.indexOf("boundary=");
            end = contentType.indexOf(";", i + 9);
            if (end == -1) {
                end = contentType.length();
            }
            len = 9;
        } else {
            end = contentType.indexOf("\"", i + 10);
            len = 10;
        }
        if (i == -1 || end == -1) {
            throw new IOException("Invalid content type: missing boundary! " + contentType);
        }
        this.boundary = "--" + contentType.substring(i + len, end);
        this.stream = new PushbackInputStream(is, this.boundary.length());
        this.contentType = contentType;
        if (!this.readTillFirstBoundary(this.stream, this.boundary.getBytes())) {
            throw new IOException("Couldn't find MIME boundary: " + this.boundary);
        }
        this.context = context;
    }

    public void addPart(Attachment part) {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Attachment getPart(String id) {
        this.readTo(id);
        return (Attachment)this.parts.get(id);
    }

    public Iterator getParts() {
        this.ensureAllPartsRead();
        return this.parts.values().iterator();
    }

    public String getSoapContentType() {
        this.ensureSoapAttachmentIsRead();
        return this.soapMessage.getHeader("Content-Type");
    }

    public Attachment getSoapMessage() {
        this.ensureSoapAttachmentIsRead();
        return this.soapMessage;
    }

    private void ensureSoapAttachmentIsRead() {
        if (this.soapMessageRead) {
            return;
        }
        try {
            this.soapMessage = this.readNextAttachment();
            this.soapMessageRead = true;
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Could not read message!", e);
        }
    }

    private void ensureAllPartsRead() {
        this.readTo(null);
    }

    private void readTo(String id) {
        this.ensureSoapAttachmentIsRead();
        try {
            Attachment a = this.readNextAttachment();
            while (a != null) {
                this.parts.put(a.getId(), a);
                a = this.readNextAttachment();
                if (a == null || id == null || !a.getId().equals(id)) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new XFireRuntimeException("Could not read message!", e);
        }
    }

    private Attachment readNextAttachment() throws IOException {
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        try {
            InternetHeaders headers = new InternetHeaders((InputStream)this.stream);
            MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(this.stream, this.boundary.getBytes());
            CachedOutputStream cos = new CachedOutputStream(this.threshold, this.tempDirectory);
            StreamedAttachments.copy(partStream, cos);
            String ct = headers.getHeader("Content-Type", null);
            this.cache.add(cos);
            AttachmentDataSource source = new AttachmentDataSource(ct, cos);
            DataHandler dh = new DataHandler((DataSource)source);
            String id = headers.getHeader("Content-ID", null);
            if (id != null && id.startsWith("<")) {
                id = id.substring(1, id.length() - 1);
            }
            SimpleAttachment att = new SimpleAttachment(id, dh);
            Enumeration e = headers.getAllHeaders();
            while (e.hasMoreElements()) {
                Header header = (Header)e.nextElement();
                att.setHeader(header.getName(), header.getValue());
            }
            return att;
        }
        catch (MessagingException e) {
            throw new IOException("Couldn't read headers.");
        }
    }

    public void setSoapContentType(String soapMimeType) {
        throw new UnsupportedOperationException();
    }

    public void setSoapMessage(Attachment soapMessage) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        this.ensureAllPartsRead();
        return this.parts.size();
    }

    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        Iterator itr = this.cache.iterator();
        while (itr.hasNext()) {
            CachedOutputStream cos = (CachedOutputStream)itr.next();
            cos.dispose();
        }
    }

    public File getTempDirectory() {
        File td = null;
        if (this.context != null) {
            td = (File)this.context.getContextualProperty(ATTACHMENT_DIRECTORY);
        }
        if (td == null) {
            td = this.tempDirectory;
        }
        return td;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public int getThreshold() {
        Integer t;
        if (this.context != null && (t = (Integer)this.context.getContextualProperty(ATTACHMENT_DIRECTORY)) != null) {
            return t;
        }
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[8096];
            int n = input.read(buffer);
            while (n > 0) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    private boolean readTillFirstBoundary(PushbackInputStream pushbackInStream, byte[] boundary) throws IOException {
        int value = pushbackInStream.read();
        pushbackInStream.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pushbackInStream.read();
            if ((byte)value != boundary[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < boundary.length && (byte)value == boundary[boundaryIndex]; ++boundaryIndex) {
                value = pushbackInStream.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End of Stream while searching for first Mime Boundary");
            }
            if (boundaryIndex != boundary.length) continue;
            pushbackInStream.read();
            return true;
        }
        return false;
    }

    private class MimeBodyPartInputStream
    extends InputStream {
        PushbackInputStream inStream;
        boolean boundaryFound = false;
        byte[] boundary;

        public MimeBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
            this.inStream = inStream;
            this.boundary = boundary;
        }

        public int read() throws IOException {
            int boundaryIndex;
            if (this.boundaryFound) {
                return -1;
            }
            int value = this.inStream.read();
            if (value == 13) {
                value = this.inStream.read();
                if (value != 10) {
                    this.inStream.unread(value);
                    return 13;
                }
                value = this.inStream.read();
                if ((byte)value != this.boundary[0]) {
                    this.inStream.unread(value);
                    this.inStream.unread(10);
                    return 13;
                }
            } else if ((byte)value != this.boundary[0]) {
                return value;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                value = this.inStream.read();
            }
            if (boundaryIndex == this.boundary.length) {
                this.boundaryFound = true;
                if (this.inStream.read() == 45 && value == 45) {
                    this.inStream.read();
                    this.inStream.read();
                }
                return -1;
            }
            if (value != -1) {
                this.inStream.unread(value);
            }
            this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
            return this.boundary[0];
        }
    }
}

