/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import org.apache.tools.ant.BuildException;
import org.codehaus.xfire.gen.Wsdl11Generator;

public class WsGen {
    private static void usage() {
        System.out.print("Usage: wsgen -wsdl wsdl.file -o outputDirectory [-p package] [-b binding] \n");
    }

    private static void missingParam(String param) {
        System.out.print("Missing param : " + param + "\n");
    }

    public static void main(String[] args) {
        String _package = null;
        String outputDirectory = null;
        String wsdl = null;
        String binding = null;
        String profile = null;
        if (args.length < 3) {
            WsGen.usage();
            return;
        }
        for (int i = 0; i < args.length; i += 2) {
            String param = args[i];
            String value = args[i + 1];
            param = param.toLowerCase().trim();
            value = value.trim();
            if ("-wsdl".equals(param)) {
                wsdl = value;
            }
            if ("-o".equals(param)) {
                outputDirectory = value;
            }
            if ("-p".equals(param)) {
                _package = value;
            }
            if (!"-b".equals(param)) continue;
            binding = value;
        }
        if (wsdl == null) {
            WsGen.missingParam("wsdl");
            WsGen.usage();
            return;
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
            System.out.print("Output directory not specified. Using current.\n");
        }
        System.out.print("Running WsGen...\n");
        System.out.print("wsdl    : " + wsdl + "\n");
        System.out.print("package : " + _package + "\n");
        System.out.print("output  : " + outputDirectory + "\n");
        System.out.print("binding : " + (binding == null ? "" : binding) + "\n");
        Wsdl11Generator generator = new Wsdl11Generator();
        generator.setDestinationPackage(_package);
        generator.setOutputDirectory(outputDirectory);
        generator.setWsdl(wsdl);
        if (binding != null) {
            generator.setBinding(binding);
        }
        if (profile != null) {
            generator.setProfile(profile);
        }
        try {
            generator.generate();
            System.out.print("Done.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }
}

