/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;

public abstract class AbstractBinding
implements MessageSerializer {
    private static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");

    public void setOperation(OperationInfo operation, MessageContext context) {
        context.getExchange().setOperation(operation);
    }

    protected void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    protected OperationInfo findOperation(Collection operations, List parameters) {
        List messageParts;
        OperationInfo o;
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            o = (OperationInfo)itr.next();
            messageParts = o.getInputMessage().getMessageParts();
            if (messageParts.size() != parameters.size() || !this.checkExactParameters(messageParts, parameters)) continue;
            return o;
        }
        itr = operations.iterator();
        while (itr.hasNext()) {
            o = (OperationInfo)itr.next();
            messageParts = o.getInputMessage().getMessageParts();
            if (messageParts.size() != parameters.size() || !this.checkParameters(messageParts, parameters)) continue;
            return o;
        }
        return null;
    }

    private boolean checkExactParameters(List messageParts, List parameters) {
        Iterator messagePartIterator = messageParts.iterator();
        Iterator parameterIterator = parameters.iterator();
        while (parameterIterator.hasNext()) {
            Object param = parameterIterator.next();
            MessagePartInfo mpi = (MessagePartInfo)messagePartIterator.next();
            if (mpi.getTypeClass().equals(param.getClass())) continue;
            return false;
        }
        return true;
    }

    private boolean checkParameters(List messageParts, List parameters) {
        Iterator messagePartIterator = messageParts.iterator();
        Iterator parameterIterator = parameters.iterator();
        while (parameterIterator.hasNext()) {
            Object param = parameterIterator.next();
            MessagePartInfo mpi = (MessagePartInfo)messagePartIterator.next();
            if (mpi.getTypeClass().isAssignableFrom(param.getClass())) continue;
            if (!param.getClass().isPrimitive() && mpi.getTypeClass().isPrimitive()) {
                return this.checkPrimitiveMatch(mpi.getTypeClass(), param.getClass());
            }
            return false;
        }
        return true;
    }

    private boolean checkPrimitiveMatch(Class clazz, Class typeClass) {
        return typeClass == Integer.class && clazz == Integer.TYPE || typeClass == Double.class && clazz == Double.TYPE || typeClass == Long.class && clazz == Long.TYPE || typeClass == Float.class && clazz == Float.TYPE || typeClass == Short.class && clazz == Short.TYPE || typeClass == Boolean.class && clazz == Boolean.TYPE || typeClass == Byte.class && clazz == Byte.TYPE;
    }

    protected MessagePartInfo findMessagePart(MessageContext context, Collection operations, QName name, int index) {
        MessagePartInfo lastChoice = null;
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            MessageInfo msgInfo = null;
            msgInfo = AbstractBinding.isClientModeOn(context) ? op.getOutputMessage() : op.getInputMessage();
            List bodyParts = msgInfo.getMessageParts();
            if (bodyParts.size() == 0 || bodyParts.size() <= index) continue;
            MessagePartInfo p = (MessagePartInfo)msgInfo.getMessageParts().get(index);
            if (p.getName().equals(name)) {
                return p;
            }
            if (!p.getSchemaType().getSchemaType().equals(XSD_ANY)) continue;
            lastChoice = p;
        }
        return lastChoice;
    }

    protected void read(InMessage inMessage, MessageContext context, Collection operations) throws XFireFault {
        ArrayList<Object> parameters = new ArrayList<Object>();
        OperationInfo opInfo = context.getExchange().getOperation();
        Binding binding = context.getBinding();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        int param = 0;
        boolean clientMode = AbstractBinding.isClientModeOn(context);
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = opInfo != null && clientMode ? (MessagePartInfo)opInfo.getOutputMessage().getMessageParts().get(param) : (opInfo != null && !clientMode ? (MessagePartInfo)opInfo.getInputMessage().getMessageParts().get(param) : this.findMessagePart(context, operations, dr.getName(), param));
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", XFireFault.SENDER);
            }
            ++param;
            parameters.add(context.getService().getBindingProvider().readParameter(p, dr, context));
        }
        if (opInfo == null && !clientMode) {
            opInfo = this.findOperation(operations, parameters);
            if (opInfo == null) {
                StringBuffer sb = new StringBuffer("Could not find appropriate operation for request ");
                sb.append(((OperationInfo)operations.iterator().next()).getName());
                sb.append('(');
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    sb.append(iterator.next().getClass().getName());
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(") in service '");
                sb.append(context.getService().getSimpleName());
                sb.append('\'');
                throw new XFireFault(sb.toString(), XFireFault.SENDER);
            }
            this.setOperation(opInfo, context);
        }
        context.getInMessage().setBody(parameters);
    }

    public static void writeParameter(XMLStreamWriter writer, MessageContext context, Object value, MessagePartInfo p, String ns) throws XFireFault, XMLStreamException {
        if (p.getSchemaType().isWriteOuter()) {
            if (ns.length() > 0) {
                String prefix = writer.getPrefix(ns);
                boolean declare = false;
                if (prefix == null) {
                    prefix = "";
                    declare = true;
                    writer.setDefaultNamespace(ns);
                }
                writer.writeStartElement(prefix, p.getName().getLocalPart(), ns);
                if (declare) {
                    writer.writeDefaultNamespace(ns);
                }
            } else {
                writer.writeStartElement(p.getName().getLocalPart());
                writer.writeDefaultNamespace("");
            }
        }
        context.getService().getBindingProvider().writeParameter(p, writer, context, value);
        if (p.getSchemaType().isWriteOuter()) {
            writer.writeEndElement();
        }
    }

    protected Object getParam(Object[] values, MessagePartInfo outParam, MessageContext context) {
        int index = outParam.getIndex();
        if (index == -1) {
            return values[0];
        }
        Object[] inParams = (Object[])context.getInMessage().getBody();
        return inParams[index];
    }

    protected Object getClientParam(Object[] values, MessagePartInfo outParam, MessageContext context) {
        return values[outParam.getIndex()];
    }

    protected String getBoundNamespace(MessageContext context, MessagePartInfo p) {
        if (p.isSchemaElement()) {
            return p.getName().getNamespaceURI();
        }
        return context.getService().getTargetNamespace();
    }

    public static boolean isClientModeOn(MessageContext context) {
        Boolean on = (Boolean)context.getProperty("client.mode");
        return on != null && on != false;
    }

    public static MessageInfo getIncomingMessageInfo(MessageContext context) {
        MessageInfo msgInfo = AbstractBinding.isClientModeOn(context) ? context.getExchange().getOperation().getOutputMessage() : context.getExchange().getOperation().getInputMessage();
        return msgInfo;
    }

    public static MessageInfo getOutgoingMessageInfo(MessageContext context) {
        MessageInfo msgInfo = AbstractBinding.isClientModeOn(context) ? context.getExchange().getOperation().getInputMessage() : context.getExchange().getOperation().getOutputMessage();
        return msgInfo;
    }
}

