/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.FaultInfoException;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.binding.ServiceConfiguration;
import org.codehaus.xfire.util.ParamReader;
import org.codehaus.xfire.util.ServiceUtils;

public class DefaultServiceConfiguration
extends ServiceConfiguration {
    private ObjectServiceFactory serviceFactory;

    public ObjectServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ObjectServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public Boolean isOperation(Method method) {
        if (this.serviceFactory.getIgnoredClasses().contains(method.getDeclaringClass().getName())) {
            return Boolean.FALSE;
        }
        int modifiers = method.getModifiers();
        return new Boolean(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers));
    }

    public Boolean isOutParam(Method method, int j) {
        return Boolean.FALSE;
    }

    public Boolean isInParam(Method method, int j) {
        return Boolean.TRUE;
    }

    public QName getInputMessageName(OperationInfo op) {
        return new QName(op.getService().getPortType().getNamespaceURI(), op.getName() + "Request");
    }

    public QName getOutputMessageName(OperationInfo op) {
        return new QName(op.getService().getPortType().getNamespaceURI(), op.getName() + "Response");
    }

    public Boolean hasOutMessage(String mep) {
        if (mep.equals("urn:xfire:mep:in")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public QName getFaultName(Service service, OperationInfo o, Class exClass, Class beanClass) {
        if (FaultInfoException.class.isAssignableFrom(exClass)) {
            try {
                Method method = exClass.getMethod("getFaultName", new Class[0]);
                QName name = (QName)method.invoke(null, new Object[0]);
                return name;
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't access getFaultName method.", e);
            }
        }
        String name = ServiceUtils.makeServiceNameFromClassName(beanClass);
        return new QName(service.getTargetNamespace(), name);
    }

    public String getAction(OperationInfo op) {
        return "";
    }

    public Boolean isHeader(Method method, int j) {
        return Boolean.FALSE;
    }

    public String getOperationName(ServiceInfo service, Method method) {
        if (service.getOperation(method.getName()) == null) {
            return method.getName();
        }
        int i = 1;
        String name;
        while (service.getOperation(name = method.getName() + i) != null) {
            ++i;
        }
        return name;
    }

    public String getMEP(Method method) {
        if (this.serviceFactory.isVoidOneWay() && method.getReturnType().equals(Void.TYPE)) {
            return "urn:xfire:mep:in";
        }
        return "urn:xfire:mep:in-out";
    }

    public Boolean isAsync(Method method) {
        return Boolean.FALSE;
    }

    public QName getInParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        QName suggestion = this.serviceFactory.getBindingProvider().getSuggestedName(endpoint, op, paramNumber);
        if (suggestion != null) {
            return suggestion;
        }
        String paramName = "";
        String[] names = ParamReader.getParameterNamesFromDebugInfo(method);
        paramName = names != null && names[paramNumber] != null ? names[paramNumber] : "in" + paramNumber;
        return new QName(endpoint.getServiceInfo().getPortType().getNamespaceURI(), paramName);
    }

    public QName getOutParameterName(Service endpoint, OperationInfo op, Method method, boolean doc) {
        QName suggestion = this.serviceFactory.getBindingProvider().getSuggestedName(endpoint, op, -1);
        if (suggestion != null) {
            return suggestion;
        }
        String pName = doc ? method.getName() : "";
        return new QName(endpoint.getServiceInfo().getPortType().getNamespaceURI(), pName + "out");
    }
}

