/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import junit.framework.TestCase;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.MessageBindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.test.XPathAssert;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.MapSession;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractXFireTest
extends TestCase {
    private ServiceFactory factory;
    private static String basedirPath;
    private XMLInputFactory defaultInputFactory = XMLInputFactory.newInstance();
    private Map namespaces = new HashMap();
    private MapSession session;
    private XFire xfire;
    public static final String RESPONSE = "response";

    protected void printNode(Document node) throws Exception {
        XMLOutputter writer = new XMLOutputter(Format.getPrettyFormat());
        writer.output(node, (OutputStream)System.out);
    }

    protected void printNode(Element node) throws Exception {
        XMLOutputter writer = new XMLOutputter(Format.getPrettyFormat());
        writer.output(node, (OutputStream)System.out);
    }

    protected Document invokeService(String service, String document) throws Exception {
        InputStream stream = this.getResourceAsStream(document);
        return this.invokeService(service, STAXUtils.createXMLStreamReader(stream, "UTF-8", null));
    }

    protected Document invokeService(String service, XMLStreamReader streamReader) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext();
        context.setSession(this.session);
        context.setXFire(this.getXFire());
        context.setProperty("urn:xfire:channel:backchannel", out);
        if (service != null) {
            context.setService(this.getServiceRegistry().getService(service));
        }
        InMessage msg = new InMessage(streamReader);
        Transport t = this.getXFire().getTransportManager().getTransport("urn:xfire:transport:local");
        Channel c = t.createChannel();
        c.receive(context, msg);
        String response = out.toString();
        if (response == null || response.length() == 0) {
            return null;
        }
        return this.readDocument(response);
    }

    protected InMessage invokeService(OutMessage msg, String transportID) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setProperty("urn:xfire:channel:backchannel", out);
        Transport t = this.getTransportManager().getTransport(transportID);
        Channel c = t.createChannel();
        msg.setChannel(c);
        msg.setSerializer(new CopySerializer());
        c.setEndpoint(new ChannelEndpoint(){

            public void onReceive(MessageContext context, InMessage msg) {
                try {
                    if (msg.getAttachments() != null) {
                        msg.getAttachments().getParts();
                    }
                    Document doc = new StaxBuilder().build(msg.getXMLStreamReader());
                    context.setExchange(new MessageExchange(context));
                    context.getExchange().setInMessage(msg);
                    msg.setProperty(AbstractXFireTest.RESPONSE, doc);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        });
        c.send(context, msg);
        return context.getInMessage();
    }

    protected Document readDocument(String text) throws XMLStreamException {
        return this.readDocument(text, this.defaultInputFactory);
    }

    protected Document readDocument(String text, XMLInputFactory ifactory) throws XMLStreamException {
        try {
            StaxBuilder builder = new StaxBuilder(ifactory);
            return builder.build(new StringReader(text));
        }
        catch (XMLStreamException e) {
            System.err.println("Could not read the document!");
            System.err.println(text);
            throw e;
        }
    }

    protected Document getWSDLDocument(String service) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(service, out);
        return this.readDocument(out.toString());
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        this.addNamespace("s", Soap11.getInstance().getNamespace());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
        this.createSession();
    }

    protected void createSession() {
        this.session = new MapSession();
    }

    public List assertValid(String xpath, Object node) throws Exception {
        return XPathAssert.assertValid(xpath, node, this.namespaces);
    }

    public List assertInvalid(String xpath, Object node) throws Exception {
        return XPathAssert.assertInvalid(xpath, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Document node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertNoFault(Document node) throws Exception {
        XPathAssert.assertNoFault(node);
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected WSDLWriter getWSDL(String service) throws Exception {
        ServiceRegistry reg = this.getServiceRegistry();
        Service hello = reg.getService(service);
        return hello.getWSDLWriter();
    }

    protected Session getSession() {
        return this.session;
    }

    protected XFire getXFire() {
        if (this.xfire == null) {
            this.xfire = new DefaultXFire();
        }
        return this.xfire;
    }

    protected TransportManager getTransportManager() {
        return this.getXFire().getTransportManager();
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.getXFire().getServiceRegistry();
    }

    public ServiceFactory getServiceFactory() {
        if (this.factory == null) {
            ObjectServiceFactory ofactory = new ObjectServiceFactory(this.getTransportManager(), new MessageBindingProvider());
            ofactory.setStyle("message");
            this.factory = ofactory;
        }
        return this.factory;
    }

    public void setServiceFactory(ServiceFactory factory) {
        this.factory = factory;
    }

    protected XFireProxyFactory getXFireProxyFactory() {
        return new XFireProxyFactory(this.getXFire());
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected Reader getResourceAsReader(String resource) {
        return new InputStreamReader(this.getResourceAsStream(resource));
    }

    public File getTestFile(String relativePath) {
        return new File(AbstractXFireTest.getBasedir(), relativePath);
    }

    public static String getBasedir() {
        if (basedirPath != null) {
            return basedirPath;
        }
        basedirPath = System.getProperty("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return basedirPath;
    }

    protected static class CopySerializer
    implements MessageSerializer {
        public void readMessage(InMessage arg0, MessageContext arg1) throws XFireFault {
        }

        public void writeMessage(OutMessage out, XMLStreamWriter writer, MessageContext ctx) throws XFireFault {
            try {
                STAXUtils.copy((XMLStreamReader)out.getBody(), writer);
            }
            catch (XMLStreamException e) {
                throw new XFireFault("Couldn't write to stream.", e, XFireFault.RECEIVER);
            }
        }
    }
}

