/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.attachments.StreamedAttachments;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.codehaus.xfire.transport.http.SoapHttpTransport;
import org.codehaus.xfire.transport.http.XFireHttpSession;
import org.codehaus.xfire.util.STAXUtils;

public class XFireServletController {
    private static ThreadLocal requests = new ThreadLocal();
    private static ThreadLocal responses = new ThreadLocal();
    private static final Log logger = LogFactory.getLog((Class)XFireServletController.class);
    protected XFire xfire;
    protected SoapHttpTransport transport;

    public XFireServletController(XFire xfire) {
        this.xfire = xfire;
        this.transport = new SoapHttpTransport(){

            public String getServiceURL(Service service) {
                HttpServletRequest req = XFireServletController.getRequest();
                if (req == null) {
                    return super.getServiceURL(service);
                }
                StringBuffer output = new StringBuffer(128);
                output.append(req.getScheme());
                output.append("://");
                output.append(req.getServerName());
                if (req.getServerPort() != 80 && req.getServerPort() != 443 && req.getServerPort() != 0) {
                    output.append(':');
                    output.append(req.getServerPort());
                }
                output.append(req.getRequestURI());
                return output.toString();
            }
        };
        this.transport.addFaultHandler(new FaultResponseCodeHandler());
        Transport oldSoap = this.getTransportManager().getTransport("http://schemas.xmlsoap.org/soap/http");
        if (oldSoap != null) {
            this.getTransportManager().unregister(oldSoap);
        }
        this.getTransportManager().register(this.transport);
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)requests.get();
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)responses.get();
    }

    protected TransportManager getTransportManager() {
        return this.getXFire().getTransportManager();
    }

    public void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String serviceName = this.getService(request);
        if (serviceName == null) {
            serviceName = "";
        }
        ServiceRegistry reg = this.getServiceRegistry();
        response.setHeader("Content-Type", "UTF-8");
        try {
            requests.set(request);
            responses.set(response);
            boolean hasService = reg.hasService(serviceName);
            if (serviceName.length() == 0 || !hasService) {
                if (!hasService) {
                    response.setStatus(404);
                }
                this.generateServices(request, response);
                return;
            }
            if (request.getQueryString() != null && request.getQueryString().trim().equalsIgnoreCase("wsdl")) {
                this.generateWSDL(response, serviceName);
            } else {
                this.invoke(request, response, serviceName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't invoke servlet request.", (Throwable)e);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            requests.set(null);
            responses.set(null);
        }
    }

    protected void generateService(HttpServletResponse response, String serviceName) throws ServletException, IOException {
        response.setContentType("text/html");
        Service endpoint = this.getServiceRegistry().getService(serviceName);
        HtmlServiceWriter writer = new HtmlServiceWriter();
        try {
            writer.write((OutputStream)response.getOutputStream(), endpoint);
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error writing HTML services list", (Throwable)e);
        }
    }

    protected void generateServices(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        HtmlServiceWriter writer = new HtmlServiceWriter(request);
        try {
            Object value = XFireFactory.newInstance().getXFire().getProperty("services.list.disabled");
            if (value != null && "true".equals(value.toString().toLowerCase())) {
                response.getOutputStream().write("Services list disabled".getBytes());
            } else {
                writer.write((OutputStream)response.getOutputStream(), this.getServiceRegistry().getServices());
            }
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error writing HTML services list", (Throwable)e);
        }
    }

    protected void invoke(HttpServletRequest request, HttpServletResponse response, String service) throws ServletException, IOException, UnsupportedEncodingException {
        Channel channel;
        response.setStatus(200);
        response.setBufferSize(8192);
        XFireHttpSession session = new XFireHttpSession(request);
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setSession(session);
        context.setService(this.getService(service));
        try {
            channel = this.transport.createChannel(request.getRequestURI());
        }
        catch (Exception e) {
            logger.debug((Object)"Couldn't open channel.", (Throwable)e);
            throw new ServletException("Couldn't open channel.", (Throwable)e);
        }
        String contentType = request.getContentType();
        if (null == contentType) {
            response.setContentType("text/html; charset=UTF-8");
            response.getWriter().write("<html><body>Invalid SOAP request.</body></html>");
            response.getWriter().close();
        } else if (contentType.toLowerCase().indexOf("multipart/related") != -1) {
            StreamedAttachments atts = new StreamedAttachments((InputStream)request.getInputStream(), request.getContentType());
            String encoding = this.getEncoding(request.getCharacterEncoding());
            XMLStreamReader reader = STAXUtils.createXMLStreamReader(atts.getSoapMessage().getDataHandler().getInputStream(), encoding, context);
            InMessage message = new InMessage(reader, request.getRequestURI());
            message.setProperty("SOAPAction", request.getHeader("SOAPAction"));
            message.setAttachments(atts);
            channel.receive(context, message);
        } else {
            XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)request.getInputStream(), request.getCharacterEncoding(), context);
            InMessage message = new InMessage(reader, request.getRequestURI());
            message.setProperty("SOAPAction", request.getHeader("SOAPAction"));
            channel.receive(context, message);
        }
    }

    private String getEncoding(String enc) throws ServletException {
        int typeI = enc.indexOf("type=");
        if (typeI == -1) {
            return null;
        }
        int charI = enc.indexOf("charset=", typeI);
        if (charI == -1) {
            return null;
        }
        int end = enc.indexOf("\"", charI);
        if (end == -1) {
            end = enc.indexOf(";", charI);
        }
        if (end == -1) {
            throw new ServletException("Invalid content type: " + enc);
        }
        return enc.substring(charI + 8, end);
    }

    protected void generateWSDL(HttpServletResponse response, String service) throws ServletException, IOException {
        Service userService = this.getXFire().getServiceRegistry().getService(service);
        Object value = userService.getProperty("wsdl.generation.disabled");
        boolean isWSDLDisabled = "true".equalsIgnoreCase(value != null ? value.toString() : null);
        if (isWSDLDisabled) {
            logger.warn((Object)("WSDL generation disabled for service :" + service));
            response.sendError(404, "No wsdl is avaiable for this service");
            return;
        }
        response.setStatus(200);
        response.setContentType("text/xml");
        this.getXFire().generateWSDL(service, (OutputStream)response.getOutputStream());
    }

    protected String getService(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        String serviceName = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXFire().getServiceRegistry().getService(name);
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }

    public static class FaultResponseCodeHandler
    extends AbstractHandler {
        public FaultResponseCodeHandler() {
            this.setPhase("transport");
        }

        public void invoke(MessageContext context) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response != null) {
                response.setStatus(500);
            }
        }
    }
}

