/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class W3CNamespaceContext
implements NamespaceContext {
    private Element currentNode;

    public String getNamespaceURI(String prefix) {
        String name = prefix;
        name = name.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        return this.getNamespaceURI(this.currentNode, name);
    }

    private String getNamespaceURI(Element e, String name) {
        Attr attr = e.getAttributeNode(name);
        if (attr == null) {
            Node n = e.getParentNode();
            if (n instanceof Element && n != e) {
                return this.getNamespaceURI((Element)n, name);
            }
        } else {
            return attr.getValue();
        }
        return null;
    }

    public String getPrefix(String uri) {
        return this.getPrefix(this.currentNode, uri);
    }

    private String getPrefix(Element e, String uri) {
        NamedNodeMap attributes = e.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr a = (Attr)attributes.item(i);
            String val = a.getValue();
            if (val == null || !val.equals(uri)) continue;
            String name = a.getNodeName();
            if (name.equals("xmlns")) {
                return "";
            }
            return name.substring(6);
        }
        Node n = e.getParentNode();
        if (n instanceof Element && n != e) {
            return this.getPrefix((Element)n, uri);
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> prefixes = new ArrayList<String>();
        String prefix = this.getPrefix(uri);
        if (prefix != null) {
            prefixes.add(prefix);
        }
        return prefixes.iterator();
    }

    public Element getElement() {
        return this.currentNode;
    }

    public void setElement(Element currentNode) {
        this.currentNode = currentNode;
    }
}

