/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.STAXUtils;
import org.jdom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBeansType
extends Type {
    public static final String XMLBEANS_NAMESPACE_HACK = "xmlbeans-namespace-hack";
    private SchemaType schemaType;
    private XmlOptions options = new XmlOptions();

    public XmlBeansType(SchemaType schemaType) {
        this.schemaType = schemaType;
        this.setTypeClass(schemaType.getJavaClass());
        this.options.setDocumentType(schemaType);
        if (schemaType.getContentModel() != null && schemaType.getContentModel().getParticleType() == 4) {
            this.setAbstract(false);
        } else {
            this.setAbstract(true);
        }
        if (!schemaType.isDocumentType() || this.isAbstract()) {
            this.setWriteOuter(true);
        } else {
            this.setWriteOuter(false);
        }
    }

    public XmlBeansType(Class clazz) {
        this(XmlBeans.typeForClass((Class)clazz));
    }

    public void writeSchema(Element root) {
    }

    public boolean isComplex() {
        return !this.schemaType.isPrimitiveType();
    }

    public Set getDependencies() {
        SchemaProperty[] properties = this.schemaType.getProperties();
        HashSet deps = new HashSet();
        for (int i = 0; i < properties.length; ++i) {
            SchemaType etype = properties[i].getType();
            SchemaProperty[] iprops = etype.getElementProperties();
            for (int j = 0; j < iprops.length; ++j) {
                SchemaType itype = iprops[j].getType();
                this.testAndAddType(deps, itype);
            }
            this.testAndAddType(deps, etype.getBaseType());
            this.testAndAddType(deps, etype.getBaseEnumType());
        }
        return deps;
    }

    private void testAndAddType(HashSet deps, SchemaType itype) {
        if (itype != null && !itype.isPrimitiveType() && itype.getSourceName() != null) {
            deps.add(new XmlBeansType(itype));
        }
    }

    public QName getSchemaType() {
        if (this.schemaType.isDocumentType()) {
            return this.schemaType.getDocumentElementName();
        }
        if (this.schemaType.getName() != null) {
            return this.schemaType.getName();
        }
        for (SchemaType outer = this.schemaType.getOuterType(); outer != null; outer = outer.getOuterType()) {
            if (outer.isDocumentType()) {
                return outer.getDocumentElementName();
            }
            if (outer.getName() == null) continue;
            return outer.getName();
        }
        throw new XFireRuntimeException("No type name is defined for <" + this.schemaType + "> " + "and no outer type containing the inline type -- this " + "should not be possible to be a legally defined schema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(MessageReader mreader, MessageContext context) throws XFireFault {
        try {
            XMLStreamReader reader = ((ElementReader)mreader).getXMLStreamReader();
            XmlObject parsed = XmlObject.Factory.parse((XMLStreamReader)reader, (XmlOptions)this.options);
            XmlCursor cursor = parsed.newCursor();
            try {
                cursor.toFirstContentToken();
                Map namespaces = (Map)context.getProperty("declared.namespaces");
                HashMap decNamespaces = new HashMap();
                cursor.getAllNamespaces(namespaces);
                Iterator itr = namespaces.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (decNamespaces.containsKey(entry.getKey())) continue;
                    cursor.insertNamespace((String)entry.getKey(), (String)entry.getValue());
                }
            }
            finally {
                cursor.dispose();
            }
            return parsed;
        }
        catch (XmlException e) {
            throw new XFireFault("Could not read request.", e, XFireFault.SENDER);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object value, MessageWriter writer, MessageContext context) throws XFireFault {
        try {
            XmlObject obj = (XmlObject)value;
            XMLStreamWriter xsw = ((ElementWriter)writer).getXMLStreamWriter();
            if (Boolean.valueOf((String)context.getContextualProperty(XMLBEANS_NAMESPACE_HACK)).booleanValue()) {
                Node o = obj.newDomNode();
                if (o instanceof Document) {
                    org.w3c.dom.Element e = ((Document)o).getDocumentElement();
                    STAXUtils.writeElement(e, xsw, false);
                    return;
                } else {
                    if (!(o instanceof DocumentFragment)) throw new XFireRuntimeException("Invalid document type returned: " + o);
                    DocumentFragment frag = (DocumentFragment)o;
                    NodeList nodes = frag.getChildNodes();
                    Node node = nodes.item(0);
                    nodes = node.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        STAXUtils.writeNode(nodes.item(i), xsw, false);
                    }
                }
                return;
            } else {
                XmlCursor cursor = obj.newCursor();
                STAXUtils.copy(cursor.newXMLStreamReader(), ((ElementWriter)writer).getXMLStreamWriter());
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not write response.", e, XFireFault.SENDER);
        }
    }

    public XmlOptions getOptions() {
        return this.options;
    }

    public void setOptions(XmlOptions options) {
        this.options = options;
    }
}

