/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations;
import org.codehaus.xfire.fault.FaultSender;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.jaxws.JAXWSBinding;
import org.codehaus.xfire.jaxws.JAXWSOperationBinding;
import org.codehaus.xfire.jaxws.handler.WebFaultHandler;
import org.codehaus.xfire.jaxws.type.JAXWSTypeRegistry;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ServiceInvocationHandler;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.transport.TransportManager;

public class JAXWSServiceFactory
extends AnnotationServiceFactory {
    public JAXWSServiceFactory(TransportManager transportManager) {
        super(new Jsr181WebAnnotations(), transportManager, new AegisBindingProvider(new JAXWSTypeRegistry()));
    }

    protected void registerHandlers(Service service) {
        service.addInHandler(new ServiceInvocationHandler());
        service.addOutHandler(new OutMessageSender());
        service.addFaultHandler(new FaultSender());
        service.addFaultHandler(new WebFaultHandler());
    }

    protected OperationInfo addOperation(Service endpoint, Method method, String style) {
        OperationInfo op = super.addOperation(endpoint, method, style);
        return op;
    }

    protected FaultInfo addFault(Service service, OperationInfo op, Class exClazz) {
        FaultInfo info = super.addFault(service, op, exClazz);
        return info;
    }

    protected boolean isFaultInfoClass(Class exClass) {
        return exClass.isAnnotationPresent(WebFault.class);
    }

    protected QName getFaultName(Service service, OperationInfo o, Class exClass, Class beanClass) {
        WebFault webFault = exClass.getAnnotation(WebFault.class);
        if (webFault == null) {
            return super.getFaultName(service, o, exClass, beanClass);
        }
        String ns = webFault.targetNamespace();
        if (ns == null) {
            ns = service.getTargetNamespace();
        }
        return new QName(ns, webFault.name());
    }

    protected void createSoapBinding(Service service, AbstractSoapBinding binding) {
        super.createSoapBinding(service, binding);
        binding.setSerializer(new JAXWSBinding(binding.getSerializer()));
    }

    public void createBindingOperation(Service service, AbstractSoapBinding binding, OperationInfo op) {
        super.createBindingOperation(service, binding, op);
        binding.setSerializer(op, new JAXWSOperationBinding(op, binding.getSerializer()));
    }

    protected QName createInputMessageName(OperationInfo op) {
        if (op.getMethod().isAnnotationPresent(RequestWrapper.class)) {
            String name;
            RequestWrapper wrapper = op.getMethod().getAnnotation(RequestWrapper.class);
            String ns = wrapper.targetNamespace();
            if (ns.length() == 0) {
                ns = op.getService().getPortType().getNamespaceURI();
            }
            if ((name = wrapper.localName()).length() == 0) {
                name = op.getName();
            }
            return new QName(ns, name);
        }
        return super.createInputMessageName(op);
    }

    protected QName createOutputMessageName(OperationInfo op) {
        if (op.getMethod().isAnnotationPresent(ResponseWrapper.class)) {
            String name;
            ResponseWrapper wrapper = op.getMethod().getAnnotation(ResponseWrapper.class);
            String ns = wrapper.targetNamespace();
            if (ns.length() == 0) {
                ns = op.getService().getPortType().getNamespaceURI();
            }
            if ((name = wrapper.localName()).length() == 0) {
                name = op.getName();
            }
            return new QName(ns, name);
        }
        return super.createOutputMessageName(op);
    }
}

