/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.security.wss4j;

import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.security.wss4j.AbstractWSS4JHandler;
import org.codehaus.xfire.soap.handler.ReadHeadersHandler;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.w3c.dom.Document;

public class WSS4JInHandler
extends AbstractWSS4JHandler
implements Handler {
    protected static Log log = LogFactory.getLog((String)WSS4JInHandler.class.getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");

    public WSS4JInHandler() {
        this.setPhase("parse");
        this.getBefore().add(ReadHeadersHandler.class.getName());
        this.getAfter().add(DOMInHandler.class.getName());
    }

    public WSS4JInHandler(Properties properties) {
        this();
        this.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws XFireFault {
        boolean doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)"WSS4JInSecurityHandler: enter invoke()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            WSSecurityEngineResult actionResult;
            reqData.setMsgContext((Object)msgContext);
            Vector actions = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)msgContext.getProperty("action");
            }
            if (action == null) {
                throw new XFireRuntimeException("WSS4JInHandler: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            AbstractMessage sm = msgContext.getCurrentMessage();
            Document doc = (Document)sm.getProperty("dom.message");
            if (doc == null) {
                throw new XFireRuntimeException("DOMInHandler must be enabled for WS-Security!");
            }
            if (sm.getBody() instanceof XFireFault) {
                return;
            }
            CallbackHandler cbHandler = null;
            if ((doAction & 5) != 0) {
                cbHandler = this.getPasswordCB(reqData);
            }
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            try {
                wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                log.error((Object)ex);
                throw new XFireFault("WSS4JInHandler: security processing failed", ex, XFireFault.SENDER);
            }
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new XFireFault("WSS4JInHandler: Request does not contain required Security header", XFireFault.SENDER);
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)2)) != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new XFireFault("WSS4JInHandler: The certificate used for the signature is not trusted", XFireFault.SENDER);
            }
            actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)32);
            if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                throw new XFireFault("WSS4JInHandler: The timestamp could not be validated", XFireFault.SENDER);
            }
            if (!this.checkReceiverResults(wsResult, actions)) {
                throw new XFireFault("WSS4JInHandler: security processing failed (actions mismatch)", XFireFault.SENDER);
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
            results.add(0, rResult);
            if (tlog.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                tlog.debug((Object)("Receive request: total= " + (t4 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " request to Axis= " + (t3 - t2) + " header, cert verify, timestamp= " + (t4 - t3) + "\n"));
            }
            if (doDebug) {
                log.debug((Object)"WSS4JInHandler: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }
}

