/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.annotations.AnnotationException;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebMethodAnnotation;
import org.codehaus.xfire.annotations.WebParamAnnotation;
import org.codehaus.xfire.annotations.WebResultAnnotation;
import org.codehaus.xfire.annotations.WebServiceAnnotation;
import org.codehaus.xfire.annotations.soap.SOAPBindingAnnotation;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;

public class AnnotationServiceFactory
extends ObjectServiceFactory
implements ServiceFactory {
    private Log log = LogFactory.getLog((Class)AnnotationServiceFactory.class);
    private WebAnnotations webAnnotations;

    public AnnotationServiceFactory() {
        this(XFireFactory.newInstance().getXFire().getTransportManager());
    }

    public AnnotationServiceFactory(TransportManager transportManager) {
        super(transportManager, (BindingProvider)new AegisBindingProvider());
        this.webAnnotations = this.getAnnotations();
    }

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager) {
        super(transportManager, (BindingProvider)new AegisBindingProvider());
        this.webAnnotations = webAnnotations;
    }

    public AnnotationServiceFactory(WebAnnotations webAnnotations, TransportManager transportManager, BindingProvider provider) {
        super(transportManager, provider);
        this.webAnnotations = webAnnotations;
    }

    protected WebAnnotations getAnnotations() {
        if (!this.isJDK5andAbove()) {
            return this.loadCommonsAttributesAnnotations();
        }
        try {
            WebAnnotations wa = (WebAnnotations)ClassLoaderUtils.loadClass((String)"org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations", ((Object)((Object)this)).getClass()).newInstance();
            return wa;
        }
        catch (Exception e) {
            return this.loadCommonsAttributesAnnotations();
        }
    }

    private WebAnnotations loadCommonsAttributesAnnotations() {
        try {
            WebAnnotations wa = (WebAnnotations)ClassLoaderUtils.loadClass((String)"org.codehaus.xfire.annotations.commons.CommonsWebAttributes", ((Object)((Object)this)).getClass()).newInstance();
            return wa;
        }
        catch (Exception e1) {
            throw new XFireRuntimeException("No WebAnnotation implementation was found!", (Throwable)e1);
        }
    }

    boolean isJDK5andAbove() {
        String v = System.getProperty("java.class.version", "44.0");
        return "49.0".compareTo(v) <= 0;
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        String style = null;
        String use = null;
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if (this.webAnnotations.hasSOAPBindingAnnotation(clazz)) {
            SOAPBindingAnnotation soapBindingAnnotation = this.webAnnotations.getSOAPBindingAnnotation(clazz);
            style = soapBindingAnnotation.getStyleString();
            use = soapBindingAnnotation.getUseString();
        }
        if (this.webAnnotations.hasWebServiceAnnotation(clazz)) {
            WebServiceAnnotation webServiceAnnotation = this.webAnnotations.getWebServiceAnnotation(clazz);
            this.assertValidImplementationClass(clazz, this.webAnnotations);
            name = this.createServiceName(clazz, webServiceAnnotation, name);
            String portType = null;
            Class endpointInterface = clazz;
            if (webServiceAnnotation.getEndpointInterface() != null && webServiceAnnotation.getEndpointInterface().length() != 0) {
                try {
                    endpointInterface = this.loadClass(webServiceAnnotation.getEndpointInterface());
                    if (!this.webAnnotations.hasWebServiceAnnotation(endpointInterface)) {
                        throw new AnnotationException("Endpoint interface " + endpointInterface.getName() + " does not have a WebService annotation");
                    }
                    WebServiceAnnotation endpointWSAnnotation = this.webAnnotations.getWebServiceAnnotation(endpointInterface);
                    namespace = this.createServiceNamespace(endpointInterface, endpointWSAnnotation, namespace);
                    portType = this.createPortType(this.makeServiceNameFromClassName(clazz), endpointWSAnnotation);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Couldn't find endpoint interface " + webServiceAnnotation.getEndpointInterface(), e);
                }
            } else {
                namespace = this.createServiceNamespace(endpointInterface, webServiceAnnotation, namespace);
                portType = this.createPortType(this.makeServiceNameFromClassName(clazz), webServiceAnnotation);
            }
            if (!properties.containsKey("objectServiceFactory.portType")) {
                properties.put("objectServiceFactory.portType", new QName(namespace, portType));
            }
            if (!properties.containsKey("objectServiceFactory.style")) {
                properties.put("objectServiceFactory.style", style);
            }
            if (!properties.containsKey("objectServiceFactory.use")) {
                properties.put("objectServiceFactory.use", use);
            }
            if (this.webAnnotations.hasHandlerChainAnnotation(clazz)) {
                this.log.error((Object)"@HandlerChain attributes are not supported yet!");
            }
            Service service = super.create(endpointInterface, name, namespace, properties);
            if (clazz != endpointInterface) {
                service.setProperty("xfire.serviceImplClass", (Object)clazz);
            }
            return service;
        }
        throw new AnnotationException("Class " + clazz.getName() + " does not have a WebService annotation");
    }

    private void assertValidImplementationClass(Class clazz, WebAnnotations webAnnotations2) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new AnnotationException("Service class cannot be abstract: " + clazz.getName());
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new AnnotationException("Service class cannot be final: " + clazz.getName());
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new AnnotationException("Service class must be an outter public class: " + clazz.getName());
        }
        WebServiceAnnotation wsAnn = webAnnotations2.getWebServiceAnnotation(clazz);
        if (wsAnn.getEndpointInterface().length() > 0) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().equals(clazz) || !webAnnotations2.hasWebMethodAnnotation(methods[i])) continue;
                throw new AnnotationException("@WebMethod attributes are only allowed on the endpointInterface! Offending class: " + clazz.getName());
            }
        }
    }

    protected Class loadClass(String endpointInterface) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass((String)endpointInterface, ((Object)((Object)this)).getClass());
    }

    protected String createServiceNamespace(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String ns = current;
        if (ns == null && webServiceAnnotation.getTargetNamespace().length() > 0) {
            ns = webServiceAnnotation.getTargetNamespace();
        }
        if (ns == null) {
            ns = NamespaceHelper.makeNamespaceFromClassName((String)clazz.getName(), (String)"http");
        }
        return ns;
    }

    protected String createServiceName(Class clazz, WebServiceAnnotation webServiceAnnotation, String current) {
        String name = current;
        if (name == null && webServiceAnnotation.getServiceName().length() > 0) {
            name = webServiceAnnotation.getServiceName();
        }
        if (name == null) {
            name = this.makeServiceNameFromClassName(clazz);
        }
        return name;
    }

    protected String createPortType(String name, WebServiceAnnotation webServiceAnnotation) {
        String portType = null;
        portType = webServiceAnnotation.getName().length() > 0 ? webServiceAnnotation.getName() : name;
        return portType;
    }

    protected String getOperationName(ServiceInfo service, Method method) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(method) && (wma = this.webAnnotations.getWebMethodAnnotation(method)).getOperationName().length() > 0) {
            return wma.getOperationName();
        }
        return super.getOperationName(service, method);
    }

    protected String getAction(OperationInfo op) {
        WebMethodAnnotation wma;
        if (this.webAnnotations.hasWebMethodAnnotation(op.getMethod()) && (wma = this.webAnnotations.getWebMethodAnnotation(op.getMethod())).getAction().length() > 0) {
            return wma.getAction();
        }
        return super.getAction(op);
    }

    protected boolean isValidMethod(Method method) {
        if (!super.isValidMethod(method)) {
            return false;
        }
        if (method.getDeclaringClass().isInterface()) {
            return true;
        }
        return this.webAnnotations.hasWebMethodAnnotation(method);
    }

    protected boolean isHeader(Method method, int paramNumber) {
        if (paramNumber != -1 && this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
            return webParamAnnotation.isHeader();
        }
        return super.isHeader(method, paramNumber);
    }

    protected boolean isInParam(Method method, int j) {
        if (this.webAnnotations.hasWebParamAnnotation(method, j)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, j);
            return webParamAnnotation.getMode() == 0 || webParamAnnotation.getMode() == 1;
        }
        return super.isInParam(method, j);
    }

    protected boolean isOutParam(Method method, int j) {
        if (this.webAnnotations.hasWebParamAnnotation(method, j)) {
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, j);
            return webParamAnnotation.getMode() == 2 || webParamAnnotation.getMode() == 1;
        }
        return super.isOutParam(method, j);
    }

    protected QName getInParameterName(Service endpoint, OperationInfo op, Method method, int paramNumber, boolean doc) {
        if (this.webAnnotations.hasWebParamAnnotation(method, paramNumber)) {
            String ns;
            WebParamAnnotation webParamAnnotation = this.webAnnotations.getWebParamAnnotation(method, paramNumber);
            String name = webParamAnnotation.getName();
            if (name == null || name.length() == 0) {
                name = super.getInParameterName(endpoint, op, method, paramNumber, doc).getLocalPart();
            }
            if ((ns = webParamAnnotation.getTargetNamespace()) == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return super.getInParameterName(endpoint, op, method, paramNumber, doc);
    }

    protected QName getOutParameterName(Service endpoint, OperationInfo op, Method method, boolean doc) {
        if (this.webAnnotations.hasWebResultAnnotation(method)) {
            String ns;
            WebResultAnnotation webResultAnnotation = this.webAnnotations.getWebResultAnnotation(method);
            String name = webResultAnnotation.getName();
            if (name == null || name.length() == 0) {
                name = super.getOutParameterName(endpoint, op, method, doc).getLocalPart();
            }
            if ((ns = webResultAnnotation.getTargetNamespace()) == null || ns.length() == 0) {
                ns = endpoint.getTargetNamespace();
            }
            return new QName(ns, name);
        }
        return super.getOutParameterName(endpoint, op, method, doc);
    }

    protected boolean isAsync(Method method) {
        boolean oneway = this.webAnnotations.hasOnewayAnnotation(method);
        if (oneway && !method.getReturnType().equals(Void.TYPE)) {
            throw new AnnotationException("Method " + method.getName() + " is marked as Oneway, but does not return void!");
        }
        return oneway;
    }

    protected String getMEP(Method method) {
        if (this.webAnnotations.hasOnewayAnnotation(method)) {
            return "urn:xfire:mep:in";
        }
        return super.getMEP(method);
    }
}

