/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.soap.handler;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.util.stax.FragmentStreamReader;
import org.jdom.Element;

public class ReadHeadersHandler
extends AbstractHandler {
    public static final String DECLARED_NAMESPACES = "declared.namespaces";

    public ReadHeadersHandler() {
        this.setPhase("parse");
    }

    public void invoke(MessageContext context) throws Exception {
        boolean end;
        InMessage message = context.getInMessage();
        if (message.hasHeader()) {
            return;
        }
        XMLStreamReader reader = message.getXMLStreamReader();
        HashMap namespaces = new HashMap();
        context.setProperty(DECLARED_NAMESPACES, namespaces);
        boolean bl = end = !reader.hasNext();
        while (!end && reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 7: {
                    String encoding = reader.getCharacterEncodingScheme();
                    message.setEncoding(encoding);
                    break;
                }
                case 8: {
                    end = true;
                    return;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (reader.getLocalName().equals("Header")) {
                        this.readHeaders(context, namespaces);
                        break;
                    }
                    if (reader.getLocalName().equals("Body")) {
                        this.readNamespaces(reader, namespaces);
                        event = reader.nextTag();
                        this.checkForFault(context, message, reader);
                        return;
                    }
                    if (!reader.getLocalName().equals("Envelope")) break;
                    this.readNamespaces(reader, namespaces);
                    message.setSoapVersion(reader.getNamespaceURI());
                    if (message.getSoapVersion() != null) break;
                    throw new XFireFault("Invalid SOAP version: " + reader.getNamespaceURI(), XFireFault.SENDER);
                }
            }
        }
    }

    private void readNamespaces(XMLStreamReader reader, Map namespaces) {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
    }

    protected void checkForFault(MessageContext context, InMessage msg, XMLStreamReader reader) throws XFireFault {
        if (reader.getEventType() == 1 && reader.getName().equals(msg.getSoapVersion().getFault())) {
            MessageSerializer serializer = context.getService().getFaultSerializer();
            serializer.readMessage(msg, context);
            throw (XFireFault)msg.getBody();
        }
    }

    protected void readHeaders(MessageContext context, Map namespaces) throws XMLStreamException {
        StaxBuilder builder = new StaxBuilder();
        InMessage msg = context.getInMessage();
        FragmentStreamReader fsr = new FragmentStreamReader(msg.getXMLStreamReader());
        fsr.setAdvanceAtEnd(false);
        builder.setAdditionalNamespaces(namespaces);
        Element header = builder.build(fsr).getRootElement();
        context.getInMessage().setHeader(header);
    }
}

