/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public abstract class AbstractWSDL
implements WSDLWriter {
    private static final StaxBuilder builder = new StaxBuilder();
    private Definition def;
    private Service service;
    private Document wsdlDocument;
    private Map dependencies = new HashMap();
    private Map namespaceImports = new HashMap();
    private Element schemaTypes;
    private Map typeMap;
    private boolean schemaLocationRemoved = true;
    public static final Namespace XSD_NS = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    public static final String GENERATE_IMPORTS = "wsdlBuilder.generateImports";
    public static final String CLEAN_IMPORTS = "wsdlBuilder.cleanImports";
    public static final String REMOVE_ALL_IMPORTS = "wsdlBuilder.removeAllImports";
    private boolean generateImports = false;
    private boolean cleanImports = true;
    private boolean removeAllImports = false;

    public AbstractWSDL(Service service) throws WSDLException {
        List schemas;
        this.service = service;
        this.setDefinition(WSDLFactory.newInstance().newDefinition());
        this.getDefinition().setTargetNamespace(this.getTargetNamespace());
        Element root = new Element("types", "wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.setSchemaTypes(root);
        root.addNamespaceDeclaration(Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema"));
        this.addNamespace("soap11", Soap11.getInstance().getNamespace());
        this.addNamespace("soapenc11", Soap11.getInstance().getSoapEncodingStyle());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
        this.addNamespace("soapenc12", Soap12.getInstance().getSoapEncodingStyle());
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("tns", this.getTargetNamespace());
        if (!this.getTargetNamespace().equals(service.getServiceInfo().getPortType().getNamespaceURI())) {
            this.addNamespace("itf", service.getServiceInfo().getPortType().getNamespaceURI());
        }
        this.typeMap = new HashMap();
        this.generateImports = Boolean.valueOf((String)service.getProperty(GENERATE_IMPORTS));
        this.removeAllImports = Boolean.valueOf((String)service.getProperty(REMOVE_ALL_IMPORTS));
        String cleanImpProp = (String)service.getProperty(CLEAN_IMPORTS);
        if (cleanImpProp != null) {
            this.cleanImports = Boolean.valueOf(cleanImpProp);
        }
        if ((schemas = (List)service.getProperty("objectServiceFactory.schemas")) != null) {
            this.addSchemas(schemas);
        }
    }

    protected void writeDocument() throws WSDLException {
        if (this.removeAllImports) {
            this.removeAllImports();
        } else {
            if (this.generateImports) {
                this.writeImports();
            }
            if (this.cleanImports) {
                this.cleanImports();
            }
        }
        org.w3c.dom.Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.def);
        this.wsdlDocument = new DOMBuilder().build(doc);
        this.writeComplexTypes();
    }

    protected void writeImports() {
        Iterator itr = this.namespaceImports.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String uri = (String)entry.getKey();
            Set imports = (Set)entry.getValue();
            Element schema = this.createSchemaType(uri);
            Iterator importItr = imports.iterator();
            while (importItr.hasNext()) {
                String ns = (String)importItr.next();
                if (ns.equals("http://www.w3.org/2001/XMLSchema") || this.getImport(schema, ns) != null) continue;
                Element importEl = new Element("import", XSD_NS);
                importEl.setAttribute(new Attribute("namespace", ns));
                schema.addContent(0, (Content)importEl);
            }
        }
    }

    public Element getImport(Element schema, String ns) {
        List children = schema.getChildren("import", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
        for (int i = 0; i < children.size(); ++i) {
            Element importEl = (Element)children.get(i);
            String value = importEl.getAttributeValue("namespace");
            if (value == null || !value.equals(ns)) continue;
            return importEl;
        }
        return null;
    }

    protected void removeAllImports() {
        Iterator itr = this.schemaTypes.getChildren().iterator();
        while (itr.hasNext()) {
            Element schema = (Element)itr.next();
            List children = schema.getChildren("import", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
            Iterator sitr = children.iterator();
            while (sitr.hasNext()) {
                sitr.next();
                sitr.remove();
            }
        }
    }

    protected void cleanImports() {
        Iterator itr = this.schemaTypes.getChildren().iterator();
        while (itr.hasNext()) {
            Element schema = (Element)itr.next();
            List children = schema.getChildren("import", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
            Iterator sitr = children.iterator();
            while (sitr.hasNext()) {
                this.cleanImport((Element)sitr.next());
            }
        }
    }

    public void cleanImport(Element node) {
        Attribute schemaLoc = node.getAttribute("schemaLocation");
        if (schemaLoc != null) {
            schemaLoc.detach();
        }
    }

    protected void writeComplexTypes() throws WSDLException {
        Element rootEl = this.getDocument().getRootElement();
        if (this.schemaTypes.getContentSize() > 0) {
            this.schemaTypes.detach();
            rootEl.addContent(0, (Content)this.schemaTypes);
        }
    }

    public void addDependency(SchemaType type) {
        if (!type.isComplex()) {
            return;
        }
        if (!this.hasDependency(type)) {
            this.dependencies.put(type.getSchemaType(), type);
            Element e = this.createSchemaType(type.getSchemaType().getNamespaceURI());
            type.writeSchema(e);
            Set deps = type.getDependencies();
            if (deps != null) {
                Iterator itr = deps.iterator();
                while (itr.hasNext()) {
                    SchemaType child = (SchemaType)itr.next();
                    this.addDependency(child);
                    this.addNamespaceImport(type.getSchemaType().getNamespaceURI(), child.getSchemaType().getNamespaceURI());
                }
            }
        }
    }

    protected boolean hasDependency(SchemaType type) {
        return this.dependencies.containsKey(type.getSchemaType());
    }

    public void addNamespaceImport(String uri, String imported) {
        if (uri.equals(imported)) {
            return;
        }
        HashSet<String> imports = (HashSet<String>)this.namespaceImports.get(uri);
        if (imports == null) {
            imports = new HashSet<String>();
            this.namespaceImports.put(uri, imports);
        }
        imports.add(imported);
    }

    public void write(OutputStream out) throws IOException {
        XMLOutputter writer = new XMLOutputter();
        writer.setFormat(Format.getPrettyFormat());
        writer.output(this.getDocument(), out);
    }

    public void addNamespace(String prefix, String uri) {
        this.def.addNamespace(prefix, uri);
        Namespace declaredUri = this.schemaTypes.getNamespace(prefix);
        if (declaredUri == null) {
            this.schemaTypes.addNamespaceDeclaration(Namespace.getNamespace((String)prefix, (String)uri));
        } else if (!declaredUri.getURI().equals(uri)) {
            throw new XFireRuntimeException("Namespace conflict: " + declaredUri + " was declared but " + uri + " was attempted.");
        }
    }

    public String getNamespacePrefix(String uri) {
        return NamespaceHelper.getUniquePrefix(this.schemaTypes, uri);
    }

    public Document getDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public void setDefinition(Definition definition) {
        this.def = definition;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String getTargetNamespace() {
        return this.service.getTargetNamespace();
    }

    public void addSchemas(List schemaLocations) {
        Iterator itr = schemaLocations.iterator();
        while (itr.hasNext()) {
            this.addSchema((String)itr.next());
        }
    }

    public void addSchema(String location) {
        String targetNamespace;
        InputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(location);
        }
        catch (FileNotFoundException e) {
            fileInputStream = ClassLoaderUtils.getResourceAsStream(location, this.getClass());
        }
        if (fileInputStream == null) {
            throw new XFireRuntimeException("Couldnt load schema file: " + location);
        }
        Document schema = null;
        try {
            schema = builder.build(fileInputStream);
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error parsing schema file: " + location, e);
        }
        if (this.isSchemaLocationRemoved()) {
            this.cleanImports(schema);
        }
        if ((targetNamespace = schema.getRootElement().getAttributeValue("targetNamespace")) == null) {
            throw new XFireRuntimeException("Could not find target namespace in schema: " + location);
        }
        Element root = schema.getRootElement();
        root.detach();
        this.setSchema(targetNamespace, root);
    }

    public boolean isSchemaLocationRemoved() {
        return this.schemaLocationRemoved;
    }

    public void setSchemaLocationRemoved(boolean schemaLocationRemoved) {
        this.schemaLocationRemoved = schemaLocationRemoved;
    }

    protected void cleanImports(Document schema) {
        List nodes = this.getMatches(schema, "//xsd:import");
        for (int i = 0; i < nodes.size(); ++i) {
            Element imp = (Element)nodes.get(i);
            Attribute loc = imp.getAttribute("schemaLocation");
            if (loc == null) continue;
            loc.detach();
        }
    }

    private List getMatches(Object doc, String xpath) {
        try {
            XPath path = XPath.newInstance((String)xpath);
            path.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            path.addNamespace("s", "http://www.w3.org/2001/XMLSchema");
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JDOMException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }

    public Element createSchemaType(String namespace) {
        Element e = (Element)this.typeMap.get(namespace);
        if (e == null) {
            e = new Element("schema", XSD_NS);
            e.setAttribute(new Attribute("targetNamespace", namespace));
            e.setAttribute(new Attribute("elementFormDefault", "qualified"));
            e.setAttribute(new Attribute("attributeFormDefault", "qualified"));
            this.setSchema(namespace, e);
        }
        return e;
    }

    protected boolean hasSchema(String namespace) {
        return this.typeMap.containsKey(namespace);
    }

    protected void setSchema(String namespace, Element schema) {
        this.typeMap.put(namespace, schema);
        this.getSchemaTypes().addContent((Content)schema);
    }

    protected Element getSchemaTypes() {
        return this.schemaTypes;
    }

    protected void setSchemaTypes(Element schemaTypes) {
        this.schemaTypes = schemaTypes;
    }
}

